import QtQuick
import QtQuick.Studio.DesignEffects

Item {
    id: searchButton
    width: 80
    height: 80
    property alias rectangleRadius: rectangle.radius

    Rectangle {
        id: rectangle
        color: "#ffffff"
        radius: 100
        anchors.fill: parent

        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#e5eaee"
            }

            GradientStop {
                position: 1
                color: "#E6EBEE"
            }
            orientation: Gradient.Vertical
        }

        DesignEffect {
            id: designEffect2
            layerBlurRadius: 1

            effects: [
                DesignDropShadow {
                    id: designDropShadow33
                    blur: 12
                    offsetX: 0
                    offsetY: -1
                    color: "#47E18383"
                },

                DesignDropShadow {
                    id: designDropShadow00
                    blur: 8
                    offsetX: 3
                    offsetY: 6
                    color: "#2e100F2E"
                },
                DesignDropShadow {
                    id: designDropShadow11
                    blur: 7
                    offsetX: -4
                    offsetY: -4
                    color: "#ffffff"
                }
            ]
        }
    }

    Image {
        id: magGlass
        anchors.verticalCenter: parent.verticalCenter
        source: "../images/magGlass.png"
        anchors.horizontalCenter: parent.horizontalCenter
        fillMode: Image.PreserveAspectFit
    }
}
