/* This file defines uid_t, gid_t, mode_t, pid_t
   Copyright (C) 2017 The Qt Company Ltd
   This file is part of elfutils.

   This file is free software; you can redistribute it and/or modify
   it under the terms of either

     * the GNU Lesser General Public License as published by the Free
       Software Foundation; either version 3 of the License, or (at
       your option) any later version

   or

     * the GNU General Public License as published by the Free
       Software Foundation; either version 2 of the License, or (at
       your option) any later version

   or both in parallel, as here.

   elfutils is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received copies of the GNU General Public License and
   the GNU Lesser General Public License along with this program.  If
   not, see <http://www.gnu.org/licenses/>.  */

#ifndef _FEATURES_H
#define _FEATURES_H 1

#include <stdint.h>

typedef uint32_t uid_t;
typedef uint32_t gid_t;
typedef uint32_t mode_t;
#ifdef _WIN64
typedef int64_t  pid_t;
#else
typedef int32_t  pid_t;
#endif

#endif /* features.h */
