/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkClient
implements StreamConsumer {
    private static final long START_TIME_ZERO = 0L;
    private static final long START_TIME_NEGATIVE_TIMEOUT = -1L;
    private final DefaultReporterFactory defaultReporterFactory;
    private final NotifiableTestStream notifiableTestStream;
    private final Map<Integer, RunListener> testSetReporters = new ConcurrentHashMap<Integer, RunListener>();
    private final Properties testVmSystemProperties;
    private final AtomicLong testSetStartedAt = new AtomicLong(0L);
    private volatile boolean saidGoodBye;
    private volatile StackTraceWriter errorInFork;

    public ForkClient(DefaultReporterFactory defaultReporterFactory, Properties testVmSystemProperties, NotifiableTestStream notifiableTestStream) {
        this.defaultReporterFactory = defaultReporterFactory;
        this.testVmSystemProperties = testVmSystemProperties;
        this.notifiableTestStream = notifiableTestStream;
    }

    protected void stopOnNextTest() {
    }

    public final void tryToTimeout(long currentTimeMillis, int forkedProcessTimeoutInSeconds) {
        if (forkedProcessTimeoutInSeconds > 0) {
            long forkedProcessTimeoutInMillis = 1000 * forkedProcessTimeoutInSeconds;
            long startedAt = this.testSetStartedAt.get();
            if (startedAt > 0L && currentTimeMillis - startedAt >= forkedProcessTimeoutInMillis) {
                this.testSetStartedAt.set(-1L);
                this.notifiableTestStream.shutdown(Shutdown.KILL);
            }
        }
    }

    public final DefaultReporterFactory getDefaultReporterFactory() {
        return this.defaultReporterFactory;
    }

    public final void consumeLine(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            this.processLine(s);
        }
    }

    private void setCurrentStartTime() {
        if (this.testSetStartedAt.get() == 0L) {
            this.testSetStartedAt.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    public final boolean hadTimeout() {
        return this.testSetStartedAt.get() == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(String s) {
        try {
            byte operationId = (byte)s.charAt(0);
            int commma = s.indexOf(",", 3);
            if (commma < 0) {
                System.out.println(s);
                return;
            }
            int channelNumber = Integer.parseInt(s.substring(2, commma), 16);
            int rest = s.indexOf(",", commma);
            String remaining = s.substring(rest + 1);
            switch (operationId) {
                case 49: {
                    this.getOrCreateReporter(channelNumber).testSetStarting(this.createReportEntry(remaining));
                    this.setCurrentStartTime();
                    break;
                }
                case 50: {
                    this.getOrCreateReporter(channelNumber).testSetCompleted(this.createReportEntry(remaining));
                    break;
                }
                case 53: {
                    this.getOrCreateReporter(channelNumber).testStarting(this.createReportEntry(remaining));
                    break;
                }
                case 54: {
                    this.getOrCreateReporter(channelNumber).testSucceeded(this.createReportEntry(remaining));
                    break;
                }
                case 56: {
                    this.getOrCreateReporter(channelNumber).testFailed(this.createReportEntry(remaining));
                    break;
                }
                case 57: {
                    this.getOrCreateReporter(channelNumber).testSkipped(this.createReportEntry(remaining));
                    break;
                }
                case 55: {
                    this.getOrCreateReporter(channelNumber).testError(this.createReportEntry(remaining));
                    break;
                }
                case 71: {
                    this.getOrCreateReporter(channelNumber).testAssumptionFailure(this.createReportEntry(remaining));
                    break;
                }
                case 73: {
                    int keyEnd = remaining.indexOf(",");
                    StringBuilder key = new StringBuilder();
                    StringBuilder value = new StringBuilder();
                    StringUtils.unescapeString((StringBuilder)key, (CharSequence)remaining.substring(0, keyEnd));
                    StringUtils.unescapeString((StringBuilder)value, (CharSequence)remaining.substring(keyEnd + 1));
                    Properties properties = this.testVmSystemProperties;
                    synchronized (properties) {
                        this.testVmSystemProperties.put(key.toString(), value.toString());
                        break;
                    }
                }
                case 51: {
                    this.writeTestOutput(channelNumber, remaining, true);
                    break;
                }
                case 52: {
                    this.writeTestOutput(channelNumber, remaining, false);
                    break;
                }
                case 72: {
                    this.getOrCreateConsoleLogger(channelNumber).info(this.createConsoleMessage(remaining));
                    break;
                }
                case 78: {
                    this.notifiableTestStream.provideNewTest();
                    break;
                }
                case 88: {
                    this.errorInFork = this.deserializeStackTraceWriter(new StringTokenizer(remaining, ","));
                    break;
                }
                case 90: {
                    this.saidGoodBye = true;
                    break;
                }
                case 83: {
                    this.stopOnNextTest();
                    break;
                }
                default: {
                    System.out.println(s);
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println(s);
        }
        catch (NoSuchElementException e) {
            System.out.println(s);
        }
        catch (ReporterException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTestOutput(int channelNumber, String remaining, boolean isStdout) {
        int csNameEnd = remaining.indexOf(44);
        String charsetName = remaining.substring(0, csNameEnd);
        String byteEncoded = remaining.substring(csNameEnd + 1);
        ByteBuffer unescaped = StringUtils.unescapeBytes((String)byteEncoded, (String)charsetName);
        if (unescaped.hasArray()) {
            byte[] convertedBytes = unescaped.array();
            this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(convertedBytes, unescaped.position(), unescaped.remaining(), isStdout);
        } else {
            byte[] convertedBytes = new byte[unescaped.remaining()];
            unescaped.get(convertedBytes, 0, unescaped.remaining());
            this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(convertedBytes, 0, convertedBytes.length, isStdout);
        }
    }

    public final void consumeMultiLineContent(String s) throws IOException {
        BufferedReader stringReader = new BufferedReader(new StringReader(s));
        String s1 = stringReader.readLine();
        while (s1 != null) {
            this.consumeLine(s1);
            s1 = stringReader.readLine();
        }
    }

    private String createConsoleMessage(String remaining) {
        return this.unescape(remaining);
    }

    private ReportEntry createReportEntry(String untokenized) {
        StringTokenizer tokens = new StringTokenizer(untokenized, ",");
        try {
            String source = this.nullableCsv(tokens.nextToken());
            String name = this.nullableCsv(tokens.nextToken());
            String group = this.nullableCsv(tokens.nextToken());
            String message = this.nullableCsv(tokens.nextToken());
            String elapsedStr = tokens.nextToken();
            Integer elapsed = "null".equals(elapsedStr) ? null : Integer.decode(elapsedStr);
            StackTraceWriter stackTraceWriter = tokens.hasMoreTokens() ? this.deserializeStackTraceWriter(tokens) : null;
            return CategorizedReportEntry.reportEntry((String)source, (String)name, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)elapsed, (String)message);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(untokenized, e);
        }
    }

    private StackTraceWriter deserializeStackTraceWriter(StringTokenizer tokens) {
        String stackTraceMessage = this.nullableCsv(tokens.nextToken());
        String smartStackTrace = this.nullableCsv(tokens.nextToken());
        String stackTrace = tokens.hasMoreTokens() ? this.nullableCsv(tokens.nextToken()) : null;
        return stackTrace != null ? new DeserializedStacktraceWriter(stackTraceMessage, smartStackTrace, stackTrace) : null;
    }

    private String nullableCsv(String source) {
        return "null".equals(source) ? null : this.unescape(source);
    }

    private String unescape(String source) {
        StringBuilder stringBuffer = new StringBuilder(source.length());
        StringUtils.unescapeString((StringBuilder)stringBuffer, (CharSequence)source);
        return stringBuffer.toString();
    }

    public final RunListener getReporter(int channelNumber) {
        return this.testSetReporters.get(channelNumber);
    }

    private RunListener getOrCreateReporter(int channelNumber) {
        RunListener reporter = this.testSetReporters.get(channelNumber);
        if (reporter == null) {
            reporter = this.defaultReporterFactory.createReporter();
            this.testSetReporters.put(channelNumber, reporter);
        }
        return reporter;
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver(int channelNumber) {
        return (ConsoleOutputReceiver)this.getOrCreateReporter(channelNumber);
    }

    private ConsoleLogger getOrCreateConsoleLogger(int channelNumber) {
        return (ConsoleLogger)this.getOrCreateReporter(channelNumber);
    }

    public void close(boolean hadTimeout) {
    }

    public final boolean isSaidGoodBye() {
        return this.saidGoodBye;
    }

    public final StackTraceWriter getErrorInFork() {
        return this.errorInFork;
    }

    public final boolean isErrorInFork() {
        return this.errorInFork != null;
    }
}

