/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.ComputableFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ItemFactoryMap<I, P>
implements Map<ComputableFactory<I, P>, I> {
    protected final HashMap<ComputableFactory<I, P>, I> itemMap;
    protected final P param;

    public ItemFactoryMap(P param) {
        this(param, 0);
    }

    public ItemFactoryMap(P param, int capacity) {
        this.itemMap = new HashMap(capacity);
        this.param = param;
    }

    public I getItem(ComputableFactory<I, P> factory) {
        I item = this.itemMap.get(factory);
        if (item == null) {
            item = factory.create(this.param);
            this.itemMap.put(factory, item);
        }
        return item;
    }

    @Override
    public I get(Object o) {
        if (o instanceof ComputableFactory) {
            return this.getItem((ComputableFactory)o);
        }
        return null;
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.itemMap.containsKey(o);
    }

    @Override
    public I put(ComputableFactory<I, P> factory, I i) {
        return this.itemMap.put(factory, i);
    }

    @Override
    public void putAll(Map<? extends ComputableFactory<I, P>, ? extends I> map) {
        this.itemMap.putAll(map);
    }

    @Override
    public I remove(Object o) {
        return this.itemMap.remove(o);
    }

    @Override
    public void clear() {
        this.itemMap.clear();
    }

    @Override
    public boolean containsValue(Object o) {
        return this.itemMap.containsValue(o);
    }

    @Override
    public Set<ComputableFactory<I, P>> keySet() {
        return this.itemMap.keySet();
    }

    @Override
    public Collection<I> values() {
        return this.itemMap.values();
    }

    @Override
    public Set<Map.Entry<ComputableFactory<I, P>, I>> entrySet() {
        return this.itemMap.entrySet();
    }
}

