/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.confluence.ConfluenceMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class ConfluenceSink
extends AbstractTextSink
implements ConfluenceMarkup {
    private final PrintWriter out;
    private StringWriter writer;
    private boolean headFlag;
    private int levelList = 0;
    private final Stack<String> listStyles;
    private boolean monospacedFlag;
    protected Stack<List<String>> inlineStack = new Stack();
    private boolean verbatimBoxedFlag;
    private boolean tableFlag;
    private boolean tableHeaderFlag;
    private String linkName;

    protected ConfluenceSink(Writer writer) {
        this.out = new PrintWriter(writer);
        this.listStyles = new Stack();
        this.init();
    }

    public void anchor(String name) {
        this.write("{anchor:" + name + "}");
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.anchor(name);
    }

    public void anchor_() {
    }

    public void author() {
    }

    public void author(SinkEventAttributes attributes) {
        this.author();
    }

    public void author_() {
    }

    public void body() {
    }

    public void body(SinkEventAttributes attributes) {
        this.body();
    }

    public void body_() {
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void comment(String comment) {
    }

    public void close() {
        this.out.write(this.writer.toString());
        this.out.close();
        this.init();
    }

    public void date() {
    }

    public void date(SinkEventAttributes attributes) {
        this.date();
    }

    public void date_() {
    }

    public void definedTerm() {
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.definedTerm();
    }

    public void definedTerm_() {
        this.writeEOL(true);
    }

    public void definition() {
        this.writer.write("??");
    }

    public void definition(SinkEventAttributes attributes) {
        this.definition();
    }

    public void definition_() {
        this.writer.write("??");
        this.writeEOL(true);
    }

    public void definitionList() {
    }

    public void definitionList(SinkEventAttributes attributes) {
    }

    public void definitionList_() {
        this.writeEOL();
    }

    public void definitionListItem() {
    }

    public void definitionListItem(SinkEventAttributes attributes) {
    }

    public void definitionListItem_() {
    }

    public void figure() {
    }

    public void figure(SinkEventAttributes attributes) {
        this.figure();
    }

    public void figure_() {
    }

    public void figureCaption() {
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.figureCaption();
    }

    public void figureCaption_() {
    }

    public void figureGraphics(String name) {
        this.writeEOL();
        this.write("!" + name + "!");
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.figureGraphics(src);
        if (attributes != null && attributes.getAttribute((Object)HTML.Attribute.ALT.toString()) != null) {
            this.write(attributes.getAttribute((Object)HTML.Attribute.ALT.toString()).toString());
            this.writeEOL(true);
        }
    }

    public void flush() {
        this.close();
        this.writer.flush();
    }

    public void head() {
        this.init();
        this.headFlag = true;
    }

    public void head(SinkEventAttributes attributes) {
        this.head();
    }

    public void head_() {
        this.headFlag = false;
    }

    public void horizontalRule() {
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.horizontalRule();
    }

    public void inline() {
        this.inline(null);
    }

    public void inline(SinkEventAttributes attributes) {
        if (!this.headFlag) {
            ArrayList<String> tags = new ArrayList<String>();
            if (attributes != null) {
                if (attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                    this.write("_");
                    tags.add(0, "_");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                    this.write("*");
                    tags.add(0, "*");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                    this.write("{{");
                    tags.add(0, "}}");
                }
            }
            this.inlineStack.push(tags);
        }
    }

    public void inline_() {
        if (!this.headFlag) {
            for (String tag : this.inlineStack.pop()) {
                this.write(tag);
            }
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void lineBreak() {
        this.write("\\\\");
        this.writeEOL();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.lineBreak();
    }

    public void link(String name) {
        this.linkName = name;
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.link(name);
    }

    public void link_() {
        this.linkName = null;
        this.write("]");
    }

    public void list() {
        if (!this.writer.toString().endsWith(EOL + EOL)) {
            this.writeEOL(true);
        }
        ++this.levelList;
    }

    public void list(SinkEventAttributes attributes) {
        this.list();
    }

    public void list_() {
        --this.levelList;
        if (this.levelList == 0) {
            this.writeEOL(true);
            this.writeEOL();
        }
    }

    public void listItem() {
        this.write(StringUtils.repeat((String)"*", (int)this.levelList) + " ");
    }

    public void listItem(SinkEventAttributes attributes) {
        this.listItem();
    }

    public void listItem_() {
        this.writeEOL(true);
    }

    public void monospaced() {
        this.monospacedFlag = true;
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.monospacedFlag = false;
        this.inline_();
    }

    public void nonBreakingSpace() {
    }

    public void numberedList(int numbering) {
        if (!this.writer.toString().endsWith(EOL + EOL)) {
            this.writeEOL(true);
        }
        ++this.levelList;
        switch (numbering) {
            default: 
        }
        String style = "#";
        this.listStyles.push(style);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.numberedList(numbering);
    }

    public void numberedList_() {
        --this.levelList;
        if (this.levelList == 0) {
            this.writeEOL(true);
            this.writeEOL();
        }
        this.listStyles.pop();
    }

    public void numberedListItem() {
        this.writeEOL(true);
        String style = this.listStyles.peek();
        this.write(StringUtils.repeat((String)style, (int)this.levelList) + ' ');
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.numberedListItem();
    }

    public void numberedListItem_() {
        this.writeEOL(true);
    }

    public void pageBreak() {
    }

    public void paragraph() {
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.paragraph();
    }

    public void paragraph_() {
        this.writeEOL(true);
        this.writeEOL();
    }

    public void rawText(String text) {
    }

    public void section(int level, SinkEventAttributes attributes) {
    }

    public void section1() {
    }

    public void section1_() {
    }

    public void section2() {
    }

    public void section2_() {
    }

    public void section3() {
    }

    public void section3_() {
    }

    public void section4() {
    }

    public void section4_() {
    }

    public void section5() {
    }

    public void section5_() {
    }

    public void section_(int level) {
    }

    public void sectionTitle() {
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level > 0 && level < 6) {
            this.write("h" + level + ". ");
        }
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public void sectionTitle3() {
        this.sectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.sectionTitle_(3);
    }

    public void sectionTitle4() {
        this.sectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.sectionTitle_(4);
    }

    public void sectionTitle5() {
        this.sectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.sectionTitle_(5);
    }

    public void sectionTitle_() {
    }

    public void sectionTitle_(int level) {
        this.writeEOL(true);
        this.writeEOL();
    }

    public void table() {
        this.tableFlag = true;
        this.writeEOL(true);
        this.writeEOL();
    }

    public void table(SinkEventAttributes attributes) {
        this.table();
    }

    public void table_() {
        this.tableFlag = false;
        this.writeEOL(true);
        this.writeEOL();
    }

    public void tableCaption() {
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.tableCaption();
    }

    public void tableCaption_() {
    }

    public void tableCell() {
        this.write(" ");
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell();
    }

    public void tableCell(String width) {
        this.tableCell();
    }

    public void tableCell_() {
        this.write(" ");
        this.write("|");
    }

    public void tableHeaderCell() {
        this.tableHeaderFlag = true;
        this.write("|");
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableHeaderCell();
    }

    public void tableHeaderCell(String width) {
        this.tableHeaderCell();
    }

    public void tableHeaderCell_() {
        this.write("|");
    }

    public void tableRow() {
        this.write("|");
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.tableRow();
    }

    public void tableRow_() {
        if (this.tableHeaderFlag) {
            this.tableHeaderFlag = false;
            this.write("|");
        }
        this.writeEOL(true);
    }

    public void tableRows(int[] justification, boolean grid) {
    }

    public void tableRows_() {
    }

    public void text(String text) {
        if (this.headFlag) {
            return;
        }
        if (this.linkName != null) {
            this.write("[");
        }
        if (this.tableFlag) {
            String strippedText = StringUtils.replace((String)text, (String)"\n", (String)"");
            if (StringUtils.isWhitespace((String)strippedText)) {
                strippedText = StringUtils.trim((String)strippedText);
            }
            this.content(strippedText);
        } else if (this.monospacedFlag) {
            this.content(text, true);
        } else {
            this.content(text);
        }
        if (this.linkName != null) {
            this.write("|" + this.linkName);
        }
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.text(text);
        } else {
            if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.write("+");
            } else if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.write("-");
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.write("~");
            } else if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.write("^");
            }
            this.text(text);
            if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.write("^");
            } else if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.write("~");
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.write("-");
            } else if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.write("+");
            }
        }
    }

    public void title() {
    }

    public void title(SinkEventAttributes attributes) {
        this.title();
    }

    public void title_() {
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
    }

    public void verbatim(boolean boxed) {
        if (boxed) {
            this.verbatimBoxedFlag = true;
        }
        if (this.verbatimBoxedFlag) {
            this.write("{code:borderStyle=solid}");
        } else {
            this.write("{noformat}");
        }
        this.writeEOL(true);
    }

    public void verbatim_() {
        if (this.verbatimBoxedFlag) {
            this.write("{code}");
        } else {
            this.write("{noformat}");
        }
        this.writeEOL(true);
        this.writeEOL();
    }

    private void write(String text) {
        this.writer.write(ConfluenceSink.unifyEOLs((String)text));
    }

    private void writeEOL() {
        this.write(EOL);
    }

    private void writeEOL(boolean trim) {
        if (!trim) {
            this.writeEOL();
            return;
        }
        String tmp = this.writer.toString().trim();
        this.writer = new StringWriter();
        this.writer.write(tmp);
        this.write(EOL);
    }

    protected void content(String text) {
        this.write(ConfluenceSink.escapeHTML(text));
    }

    protected void content(String text, boolean escapeConfluence) {
        if (escapeConfluence) {
            this.write(ConfluenceSink.escapeConfluence(ConfluenceSink.escapeHTML(text)));
        } else {
            this.content(text);
        }
    }

    protected void init() {
        super.init();
        this.writer = new StringWriter();
        this.monospacedFlag = false;
        this.headFlag = false;
        this.levelList = 0;
        this.listStyles.clear();
        this.verbatimBoxedFlag = false;
        this.tableHeaderFlag = false;
        this.linkName = null;
    }

    protected static String escapeConfluence(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '{': {
                    buffer.append("\\{");
                    continue block4;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML((String)text);
    }
}

