/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreLocation;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.DynamicObjectBasic;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.ShapeBasic;
import java.util.EnumSet;

class DefaultLayout
extends LayoutImpl {
    private final CoreLocations.ObjectLocation[] objectFields;
    private final CoreLocations.LongLocation[] primitiveFields;
    private final CoreLocation objectArrayLocation;
    private final CoreLocation primitiveArrayLocation;

    DefaultLayout(EnumSet<Layout.ImplicitCast> allowedImplicitCasts, Class<? extends DynamicObject> dynamicObjectClass, LayoutStrategy strategy) {
        super(allowedImplicitCasts, dynamicObjectClass, strategy);
        assert (dynamicObjectClass == DynamicObjectBasic.class);
        this.objectFields = DynamicObjectBasic.OBJECT_FIELD_LOCATIONS;
        this.primitiveFields = DynamicObjectBasic.PRIMITIVE_FIELD_LOCATIONS;
        this.primitiveArrayLocation = DynamicObjectBasic.PRIMITIVE_ARRAY_LOCATION;
        this.objectArrayLocation = DynamicObjectBasic.OBJECT_ARRAY_LOCATION;
    }

    @Override
    public DynamicObject newInstance(Shape shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Shape newShape(Object objectType, Object sharedData, int flags) {
        return new ShapeBasic((Layout)this, sharedData, (ObjectType)objectType, flags);
    }

    @Override
    protected boolean hasObjectExtensionArray() {
        return true;
    }

    @Override
    protected boolean hasPrimitiveExtensionArray() {
        return true;
    }

    @Override
    protected int getObjectFieldCount() {
        return this.objectFields.length;
    }

    @Override
    protected int getPrimitiveFieldCount() {
        return this.primitiveFields.length;
    }

    @Override
    protected CoreLocation getObjectArrayLocation() {
        return this.objectArrayLocation;
    }

    @Override
    protected CoreLocation getPrimitiveArrayLocation() {
        return this.primitiveArrayLocation;
    }

    protected CoreLocations.ObjectLocation getObjectFieldLocation(int index) {
        return this.objectFields[index];
    }

    protected CoreLocations.LongLocation getPrimitiveFieldLocation(int index) {
        return this.primitiveFields[index];
    }

    protected int getLongFieldSize() {
        return 1;
    }

    @Override
    public Shape.Allocator createAllocator() {
        DefaultLayout layout = this;
        return this.getStrategy().createAllocator(layout);
    }
}

