/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class DefaultPlexusConfiguration
implements PlexusConfiguration {
    private static final PlexusConfiguration[] NO_CHILDREN = new PlexusConfiguration[0];
    private final String name;
    private String value;
    private List<PlexusConfiguration> childIndex = Collections.emptyList();
    private Map<String, List<PlexusConfiguration>> childMap = Collections.emptyMap();
    private Map<String, String> attributeMap = Collections.emptyMap();

    public DefaultPlexusConfiguration(String name) {
        this(name, null);
    }

    public DefaultPlexusConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final String getValue(String defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    @Override
    public final void setValue(String value) {
        this.value = value;
    }

    @Override
    public final String[] getAttributeNames() {
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.size()]);
    }

    @Override
    public final String getAttribute(String attributeName) {
        return this.attributeMap.get(attributeName);
    }

    @Override
    public final String getAttribute(String attributeName, String defaultValue) {
        String attributeValue = this.attributeMap.get(attributeName);
        return attributeValue != null ? attributeValue : defaultValue;
    }

    @Override
    public final void setAttribute(String attributeName, String attributeValue) {
        if (this.attributeMap.isEmpty()) {
            this.attributeMap = new HashMap<String, String>();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    @Override
    public final PlexusConfiguration getChild(String childName) {
        return this.getChild(childName, true);
    }

    @Override
    public final PlexusConfiguration getChild(String childName, boolean create) {
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (children != null) {
            return children.get(0);
        }
        return create ? this.add(this.createChild(childName)) : null;
    }

    @Override
    public final PlexusConfiguration[] getChildren() {
        return this.childIndex.toArray(new PlexusConfiguration[this.childIndex.size()]);
    }

    @Override
    public final PlexusConfiguration[] getChildren(String childName) {
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (children != null) {
            return children.toArray(new PlexusConfiguration[children.size()]);
        }
        return NO_CHILDREN;
    }

    @Override
    public final int getChildCount() {
        return this.childIndex.size();
    }

    @Override
    public final PlexusConfiguration getChild(int index) {
        return this.childIndex.get(index);
    }

    @Override
    public final void addChild(PlexusConfiguration child) {
        this.add(child);
    }

    @Override
    public final PlexusConfiguration addChild(String childName, String childValue) {
        this.add(this.createChild(childName)).setValue(childValue);
        return this;
    }

    protected PlexusConfiguration createChild(String childName) {
        return new DefaultPlexusConfiguration(childName);
    }

    protected final PlexusConfiguration add(PlexusConfiguration child) {
        String childName = child.getName();
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (children == null) {
            children = new ArrayList<PlexusConfiguration>();
            if (this.childMap.isEmpty()) {
                this.childMap = new LinkedHashMap<String, List<PlexusConfiguration>>();
                this.childIndex = new ArrayList<PlexusConfiguration>();
            }
            this.childMap.put(childName, children);
        }
        this.childIndex.add(child);
        children.add(child);
        return child;
    }
}

