/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.ReadableByteChannel;

abstract class AbstractNoninterruptibleReadableChannel
implements ReadableByteChannel {
    private volatile boolean open = true;

    AbstractNoninterruptibleReadableChannel() {
    }

    protected abstract int readImpl(ByteBuffer var1) throws IOException;

    protected abstract void closeImpl() throws IOException;

    @Override
    public final int read(ByteBuffer src) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!src.hasArray() || src.isReadOnly()) {
            throw new NonReadableChannelException();
        }
        return src.hasRemaining() ? this.readImpl(src) : 0;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final void close() throws IOException {
        try {
            this.closeImpl();
        }
        finally {
            this.open = false;
        }
    }
}

