/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.AllocationListener;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecuteSourceEvent;
import com.oracle.truffle.api.instrumentation.ExecuteSourceListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentAccessor;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.RootNodeBits;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.io.MessageTransport;

final class InstrumentationHandler {
    static final boolean TRACE = Boolean.getBoolean("truffle.instrumentation.trace");
    private final Object polyglotEngine;
    private final Map<Source, Void> sources = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicReference<SourceList> sourcesListRef = new AtomicReference();
    private volatile boolean hasSourceBindings;
    private volatile boolean collectingSources;
    private final Map<Source, Void> sourcesExecuted = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicReference<SourceList> sourcesExecutedListRef = new AtomicReference();
    private volatile boolean hasSourceExecutedBindings;
    private volatile boolean collectingSourcesExecuted;
    final Collection<RootNode> loadedRoots = new WeakAsyncList<RootNode>(256);
    private final Collection<RootNode> executedRoots = new WeakAsyncList<RootNode>(64);
    private final Collection<AllocationReporter> allocationReporters = new WeakAsyncList<AllocationReporter>(16);
    private final Collection<EventBinding.Source<?>> executionBindings = new EventBindingList(8);
    private final Collection<EventBinding.Source<?>> sourceSectionBindings = new EventBindingList(8);
    private final Collection<EventBinding.Source<?>> sourceBindings = new EventBindingList(8);
    private final ThreadLocal<FindSourcesVisitor> findSourcesVisitor = new ThreadLocalSourcesVisitor();
    private final Collection<EventBinding.Source<?>> sourceExecutedBindings = new EventBindingList(8);
    private final ThreadLocal<FindSourcesVisitor> findSourcesExecutedVisitor = new ThreadLocalExecutedSourcesVisitor();
    private final Collection<EventBinding<? extends OutputStream>> outputStdBindings = new EventBindingList<EventBinding<? extends OutputStream>>(1);
    private final Collection<EventBinding<? extends OutputStream>> outputErrBindings = new EventBindingList<EventBinding<? extends OutputStream>>(1);
    private final Collection<EventBinding.Allocation<? extends AllocationListener>> allocationBindings = new EventBindingList<EventBinding.Allocation<? extends AllocationListener>>(2);
    private final Collection<EventBinding<? extends ContextsListener>> contextsBindings = new EventBindingList<EventBinding<? extends ContextsListener>>(8);
    private final Collection<EventBinding<? extends ThreadsListener>> threadsBindings = new EventBindingList<EventBinding<? extends ThreadsListener>>(8);
    private final ReadWriteLock sourceBindingsLock = new ReentrantReadWriteLock();
    private final ReadWriteLock sourceExecutedBindingsLock = new ReentrantReadWriteLock();
    final ConcurrentHashMap<Object, AbstractInstrumenter> instrumenterMap = new ConcurrentHashMap();
    private DispatchOutputStream out;
    private DispatchOutputStream err;
    private InputStream in;
    private MessageTransport messageInterceptor;
    private final Map<Class<?>, Set<Class<?>>> cachedProvidedTags = new ConcurrentHashMap();
    final EngineInstrumenter engineInstrumenter;

    InstrumentationHandler(Object polyglotEngine, DispatchOutputStream out, DispatchOutputStream err, InputStream in, MessageTransport messageInterceptor) {
        this.polyglotEngine = polyglotEngine;
        this.out = out;
        this.err = err;
        this.in = in;
        this.messageInterceptor = messageInterceptor;
        this.engineInstrumenter = new EngineInstrumenter();
    }

    Object getSourceVM() {
        return this.polyglotEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void onLoad(RootNode root) {
        if (!InstrumentAccessor.nodesAccess().isInstrumentable(root)) {
            return;
        }
        if (!InstrumentationHandler.$assertionsDisabled && root.getLanguageInfo() == null) {
            throw new AssertionError();
        }
        if (this.hasSourceBindings) {
            lock = this.sourceBindingsLock.readLock();
            lock.lock();
            try {
                if (!this.sourceBindings.isEmpty() || this.collectingSources) {
                    this.lazyInitializeSourcesList();
                    visitor = this.findSourcesVisitor.get();
                    sourceSection = root.getSourceSection();
                    if (sourceSection != null) {
                        visitor.adoptSource(sourceSection.getSource());
                    }
                    this.visitRootAndRestoreVisitorState(root, visitor, true);
                    rootSources = visitor.getSources();
                } else {
                    this.hasSourceBindings = false;
                    this.sources.clear();
                    this.sourcesListRef.set(null);
                    rootSources = null;
                }
                this.loadedRoots.add(root);
                if (rootSources == null || (sourceList = this.sourcesListRef.get()) != null && SourceList.access$200(sourceList, rootSources)) ** GOTO lbl34
                for (Source src : rootSources) {
                    InstrumentationHandler.notifySourceBindingsLoaded(this.sourceBindings, src);
                }
            }
            finally {
                lock.unlock();
            }
        } else {
            this.loadedRoots.add(root);
        }
lbl34:
        // 3 sources

        if (!this.sourceSectionBindings.isEmpty()) {
            visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addNotifyLoadedOperationForAllBindings(VisitOperation.Scope.ALL);
            this.visitRoot(root, root, visitorBuilder.buildVisitor(), false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitRootAndRestoreVisitorState(RootNode root, FindSourcesVisitor visitor, boolean firstExecution) {
        RootNode previousRoot = visitor.root;
        Set previousProvidedTags = visitor.providedTags;
        SourceSection previousRootSourceSection = visitor.rootSourceSection;
        int previousRootBits = visitor.rootBits;
        int previousComputingRootNodeBits = visitor.computingRootNodeBits;
        boolean previousFirstExecution = visitor.firstExecution;
        boolean previousVisitingRetiredNodes = visitor.visitingRetiredNodes;
        boolean previousVisitingMaterialized = visitor.visitingMaterialized;
        Set previousMaterializeTags = visitor.materializeTags;
        try {
            this.visitRoot(root, root, visitor, false, firstExecution);
        }
        finally {
            visitor.root = previousRoot;
            visitor.providedTags = previousProvidedTags;
            visitor.rootSourceSection = previousRootSourceSection;
            visitor.rootBits = previousRootBits;
            visitor.computingRootNodeBits = previousComputingRootNodeBits;
            visitor.firstExecution = previousFirstExecution;
            visitor.visitingRetiredNodes = previousVisitingRetiredNodes;
            visitor.visitingMaterialized = previousVisitingMaterialized;
            visitor.materializeTags = previousMaterializeTags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void onFirstExecution(RootNode root) {
        if (!InstrumentAccessor.nodesAccess().isInstrumentable(root)) {
            return;
        }
        if (!InstrumentationHandler.$assertionsDisabled && root.getLanguageInfo() == null) {
            throw new AssertionError();
        }
        if (this.hasSourceExecutedBindings) {
            lock = this.sourceExecutedBindingsLock.readLock();
            lock.lock();
            try {
                if (!this.sourceExecutedBindings.isEmpty() || this.collectingSourcesExecuted) {
                    this.lazyInitializeSourcesExecutedList();
                    rootBits = RootNodeBits.get(root);
                    if (RootNodeBits.isNoSourceSection(rootBits)) {
                        rootSources = null;
                    } else {
                        visitor = this.findSourcesExecutedVisitor.get();
                        sourceSection = root.getSourceSection();
                        if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                            source = sourceSection.getSource();
                            visitor.adoptSource(source);
                        } else {
                            if (sourceSection != null) {
                                visitor.adoptSource(sourceSection.getSource());
                            }
                            this.visitRootAndRestoreVisitorState(root, visitor, true);
                        }
                        rootSources = visitor.getSources();
                    }
                } else {
                    this.hasSourceExecutedBindings = false;
                    this.sourcesExecuted.clear();
                    this.sourcesExecutedListRef.set(null);
                    rootSources = null;
                }
                this.executedRoots.add(root);
                if (rootSources == null || (sourceList = this.sourcesExecutedListRef.get()) != null && SourceList.access$200(sourceList, rootSources)) ** GOTO lbl42
                for (Source src : rootSources) {
                    InstrumentationHandler.notifySourceExecutedBindings(this.sourceExecutedBindings, src);
                }
            }
            finally {
                lock.unlock();
            }
        } else {
            this.executedRoots.add(root);
        }
lbl42:
        // 3 sources

        if (!this.executionBindings.isEmpty()) {
            visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addInsertWrapperOperationForAllBindings(VisitOperation.Scope.ALL);
            this.visitRoot(root, root, visitorBuilder.buildVisitor(), false, true);
        }
    }

    void initializeInstrument(Object polyglotInstrument, String instrumentClassName, Supplier<? extends Object> instrumentSupplier) {
        if (TRACE) {
            InstrumentationHandler.trace("Initialize instrument class %s %n", instrumentClassName);
        }
        TruffleInstrument.Env env = new TruffleInstrument.Env(polyglotInstrument, this.out, this.err, this.in, this.messageInterceptor);
        try {
            TruffleInstrument instrument = (TruffleInstrument)instrumentSupplier.get();
            env.instrumenter = new InstrumentClientInstrumenter(env, instrumentClassName);
            env.instrumenter.instrument = instrument;
        }
        catch (Exception e) {
            InstrumentationHandler.failInstrumentInitialization(env, String.format("Failed to create new instrumenter class %s", instrumentClassName), e);
            return;
        }
        if (TRACE) {
            InstrumentationHandler.trace("Initialized instrument %s class %s %n", env.instrumenter.instrument, instrumentClassName);
        }
        this.addInstrumenter(polyglotInstrument, env.instrumenter);
    }

    void createInstrument(Object vmObject, String[] expectedServices, OptionValues optionValues) {
        InstrumentClientInstrumenter instrumenter = (InstrumentClientInstrumenter)this.instrumenterMap.get(vmObject);
        ((InstrumentClientInstrumenter)instrumenter).env.options = optionValues;
        instrumenter.create(expectedServices);
    }

    void finalizeInstrumenter(Object key) {
        AbstractInstrumenter finalisingInstrumenter = this.instrumenterMap.get(key);
        if (finalisingInstrumenter == null) {
            throw new AssertionError((Object)"Instrumenter already disposed.");
        }
        finalisingInstrumenter.doFinalize();
    }

    void disposeInstrumenter(Object key, boolean cleanupRequired) {
        AbstractInstrumenter disposedInstrumenter = this.instrumenterMap.remove(key);
        if (disposedInstrumenter == null) {
            throw new AssertionError((Object)"Instrumenter already disposed.");
        }
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose instrumenter %n", key);
        }
        disposedInstrumenter.dispose();
        if (cleanupRequired) {
            Collection<EventBinding.Source<?>> disposedExecutionBindings = InstrumentationHandler.filterBindingsForInstrumenter(this.executionBindings, disposedInstrumenter);
            if (!disposedExecutionBindings.isEmpty()) {
                BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
                visitorBuilder.addDisposeWrapperOperationForBindings(disposedExecutionBindings);
                this.visitRoots(this.executedRoots, visitorBuilder.buildVisitor());
            }
            InstrumentationHandler.disposeBindingsBulk(disposedExecutionBindings);
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceSectionBindings, disposedInstrumenter));
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceBindings, disposedInstrumenter));
            InstrumentationHandler.disposeOutputBindingsBulk(this.out, this.outputStdBindings);
            InstrumentationHandler.disposeOutputBindingsBulk(this.err, this.outputErrBindings);
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed instrumenter %n", key);
        }
    }

    private static void disposeBindingsBulk(Collection<EventBinding.Source<?>> list) {
        for (EventBinding eventBinding : list) {
            eventBinding.disposeBulk();
        }
    }

    private static void disposeOutputBindingsBulk(DispatchOutputStream dos, Collection<EventBinding<? extends OutputStream>> list) {
        for (EventBinding<? extends OutputStream> binding : list) {
            InstrumentAccessor.engineAccess().detachOutputConsumer(dos, binding.getElement());
            binding.disposeBulk();
        }
    }

    Instrumenter forLanguage(TruffleLanguage<?> language) {
        return new LanguageClientInstrumenter(language);
    }

    <T> EventBinding<T> addExecutionBinding(EventBinding.Source<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.executionBindings.add(binding);
        if (!this.executedRoots.isEmpty()) {
            BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addInsertWrapperOperationForBinding(VisitOperation.Scope.ONLY_ORIGINAL, binding);
            visitorBuilder.addInsertWrapperOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            visitorBuilder.addNotifyLoadedOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            this.visitRoots(this.executedRoots, visitorBuilder.buildVisitor());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    <T> EventBinding<T> addSourceSectionBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceSectionBindings.add(binding);
        if (notifyLoaded && !this.loadedRoots.isEmpty()) {
            BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addNotifyLoadedOperationForBinding(VisitOperation.Scope.ONLY_ORIGINAL, binding);
            visitorBuilder.addNotifyLoadedOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            visitorBuilder.addInsertWrapperOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            this.visitRoots(this.loadedRoots, visitorBuilder.buildVisitor());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    private void visitLoadedSourceSections(EventBinding.Source<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visiting loaded source sections %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (!this.loadedRoots.isEmpty()) {
            BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addNotifyLoadedOperationForBinding(VisitOperation.Scope.ALL, binding);
            visitorBuilder.addNotifyLoadedOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            visitorBuilder.addInsertWrapperOperationForAllBindings(VisitOperation.Scope.ONLY_MATERIALIZED);
            this.visitRoots(this.loadedRoots, visitorBuilder.buildVisitor());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Visited loaded source sections %s, %s%n", binding.getFilter(), binding.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> EventBinding<T> addSourceBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (notifyLoaded) {
            this.collectingSources = true;
            this.hasSourceBindings = true;
            this.lazyInitializeSourcesList();
        }
        Lock lock = this.sourceBindingsLock.writeLock();
        lock.lock();
        try {
            this.sourceBindings.add(binding);
            this.hasSourceBindings = true;
            if (notifyLoaded) {
                this.collectingSources = false;
                for (Source source : this.sourcesListRef.get().getCompleteList()) {
                    InstrumentationHandler.notifySourceBindingLoaded(binding, source);
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> EventBinding<T> addSourceExecutionBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding source execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (notifyLoaded) {
            this.collectingSourcesExecuted = true;
            this.hasSourceExecutedBindings = true;
            this.lazyInitializeSourcesExecutedList();
        }
        Lock lock = this.sourceExecutedBindingsLock.writeLock();
        lock.lock();
        try {
            this.sourceExecutedBindings.add(binding);
            this.hasSourceExecutedBindings = true;
            if (notifyLoaded) {
                this.collectingSourcesExecuted = false;
                for (Source source : this.sourcesExecutedListRef.get().getCompleteList()) {
                    InstrumentationHandler.notifySourceExecutedBinding(binding, source);
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added source execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    <T extends OutputStream> EventBinding<T> addOutputBinding(EventBinding<T> binding, boolean errorOutput) {
        String kind;
        if (TRACE) {
            kind = errorOutput ? "error" : "standard";
            InstrumentationHandler.trace("BEGIN: Adding " + kind + " output binding %s%n", binding.getElement());
        }
        if (errorOutput) {
            this.outputErrBindings.add(binding);
            InstrumentAccessor.engineAccess().attachOutputConsumer(this.err, (OutputStream)binding.getElement());
        } else {
            this.outputStdBindings.add(binding);
            InstrumentAccessor.engineAccess().attachOutputConsumer(this.out, (OutputStream)binding.getElement());
        }
        if (TRACE) {
            kind = errorOutput ? "error" : "standard";
            InstrumentationHandler.trace("END: Added " + kind + " output binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends AllocationListener> EventBinding<T> addAllocationBinding(EventBinding.Allocation<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding allocation binding %s%n", binding.getElement());
        }
        this.allocationBindings.add(binding);
        for (AllocationReporter allocationReporter : this.allocationReporters) {
            if (!binding.getAllocationFilter().contains(allocationReporter.language)) continue;
            allocationReporter.addListener((AllocationListener)binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added allocation binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends ContextsListener> EventBinding<T> addContextsBinding(EventBinding<T> binding, boolean includeActiveContexts) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding contexts binding %s%n", binding.getElement());
        }
        this.contextsBindings.add(binding);
        if (includeActiveContexts) {
            Accessor.EngineSupport engineAccess = InstrumentAccessor.engineAccess();
            engineAccess.reportAllLanguageContexts(this.polyglotEngine, binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added contexts binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends ThreadsListener> EventBinding<T> addThreadsBinding(EventBinding<T> binding, boolean includeStartedThreads) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding threads binding %s%n", binding.getElement());
        }
        this.threadsBindings.add(binding);
        if (includeStartedThreads) {
            Accessor.EngineSupport engineAccess = InstrumentAccessor.engineAccess();
            engineAccess.reportAllContextThreads(this.polyglotEngine, binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added threads binding %s%n", binding.getElement());
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitializeSourcesList() {
        SourceList sourceList;
        if (this.sourcesListRef.get() == null && this.sourcesListRef.compareAndSet(null, sourceList = new SourceList())) {
            try {
                for (RootNode root : this.loadedRoots) {
                    int rootBits = RootNodeBits.get(root);
                    if (RootNodeBits.isNoSourceSection(rootBits)) continue;
                    SourceSection sourceSection = root.getSourceSection();
                    if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                        Source source = sourceSection.getSource();
                        if (this.sources.containsKey(source)) continue;
                        this.sources.put(source, null);
                        sourceList.add(source);
                        continue;
                    }
                    FindSourcesVisitor visitor = this.findSourcesVisitor.get();
                    if (sourceSection != null) {
                        visitor.adoptSource(sourceSection.getSource());
                    }
                    this.visitRootAndRestoreVisitorState(root, visitor, false);
                    Source[] visitedSources = visitor.getSources();
                    if (visitedSources == null) continue;
                    for (Source source : visitedSources) {
                        if (this.sources.containsKey(source)) continue;
                        this.sources.put(source, null);
                        sourceList.add(source);
                    }
                }
            }
            finally {
                sourceList.notifyComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitializeSourcesExecutedList() {
        SourceList sourcesExecutedList;
        if (this.sourcesExecutedListRef.get() == null && this.sourcesExecutedListRef.compareAndSet(null, sourcesExecutedList = new SourceList())) {
            try {
                for (RootNode root : this.executedRoots) {
                    int rootBits = RootNodeBits.get(root);
                    if (RootNodeBits.isNoSourceSection(rootBits)) continue;
                    SourceSection sourceSection = root.getSourceSection();
                    if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                        Source source = sourceSection.getSource();
                        if (this.sourcesExecuted.containsKey(source)) continue;
                        this.sourcesExecuted.put(source, null);
                        sourcesExecutedList.add(source);
                        continue;
                    }
                    FindSourcesVisitor visitor = this.findSourcesExecutedVisitor.get();
                    if (sourceSection != null) {
                        visitor.adoptSource(sourceSection.getSource());
                    }
                    this.visitRootAndRestoreVisitorState(root, visitor, false);
                    Source[] visitedSources = visitor.getSources();
                    if (visitedSources == null) continue;
                    for (Source source : visitedSources) {
                        if (this.sourcesExecuted.containsKey(source)) continue;
                        this.sourcesExecuted.put(source, null);
                        sourcesExecutedList.add(source);
                    }
                }
            }
            finally {
                sourcesExecutedList.notifyComplete();
            }
        }
    }

    private void visitRoots(Collection<RootNode> roots, AbstractNodeVisitor addBindingsVisitor) {
        for (RootNode root : roots) {
            this.visitRoot(root, root, addBindingsVisitor, false, false);
        }
    }

    void disposeBinding(EventBinding<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose binding %s%n", binding.getElement());
        }
        if (binding instanceof EventBinding.Source) {
            EventBinding.Source sourceBinding = (EventBinding.Source)binding;
            if (sourceBinding.isExecutionEvent()) {
                BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
                visitorBuilder.addDisposeWrapperOperationForBinding(sourceBinding);
                this.visitRoots(this.executedRoots, visitorBuilder.buildVisitor());
            }
        } else if (binding instanceof EventBinding.Allocation) {
            EventBinding.Allocation allocationBinding = (EventBinding.Allocation)binding;
            AllocationListener l = (AllocationListener)binding.getElement();
            for (AllocationReporter allocationReporter : this.allocationReporters) {
                if (!allocationBinding.getAllocationFilter().contains(allocationReporter.language)) continue;
                allocationReporter.removeListener(l);
            }
        } else {
            Object elm = binding.getElement();
            if (elm instanceof OutputStream) {
                if (this.outputErrBindings.contains(binding)) {
                    InstrumentAccessor.engineAccess().detachOutputConsumer(this.err, (OutputStream)elm);
                } else if (this.outputStdBindings.contains(binding)) {
                    InstrumentAccessor.engineAccess().detachOutputConsumer(this.out, (OutputStream)elm);
                }
            } else if (!(elm instanceof ContextsListener) && !(elm instanceof ThreadsListener)) assert (false) : "Unexpected binding " + binding + " with element " + elm;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed binding %s%n", binding.getElement());
        }
    }

    ProbeNode.EventChainNode createBindings(VirtualFrame frame, ProbeNode probeNodeImpl) {
        Node parentNode;
        EventContext context = probeNodeImpl.getContext();
        SourceSection sourceSection = context.getInstrumentedSourceSection();
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Lazy update for %s%n", sourceSection);
        }
        Node parentInstrumentable = null;
        SourceSection parentInstrumentableSourceSection = null;
        for (parentNode = probeNodeImpl.getParent(); parentNode != null && parentNode.getParent() != null; parentNode = parentNode.getParent()) {
            if (parentInstrumentable != null) continue;
            SourceSection parentSourceSection = parentNode.getSourceSection();
            if (!InstrumentationHandler.isInstrumentableNode(parentNode)) continue;
            parentInstrumentable = parentNode;
            parentInstrumentableSourceSection = parentSourceSection;
        }
        if (!(parentNode instanceof RootNode)) {
            throw new AssertionError();
        }
        RootNode rootNode = (RootNode)parentNode;
        Node instrumentedNode = probeNodeImpl.getContext().getInstrumentedNode();
        Set<Class<?>> providedTags = this.getProvidedTags(rootNode);
        ProbeNode.EventChainNode root = null;
        ProbeNode.EventChainNode parent = null;
        for (EventBinding.Source<?> binding : this.executionBindings) {
            ProbeNode.EventChainNode next;
            if (binding.isChildInstrumentedFull(providedTags, rootNode, parentInstrumentable, parentInstrumentableSourceSection, instrumentedNode, sourceSection)) {
                if (TRACE) {
                    InstrumentationHandler.trace("  Found input value binding %s, %s%n", binding.getInputFilter(), System.identityHashCode(binding));
                }
                if ((next = probeNodeImpl.createParentEventChainCallback(frame, binding, rootNode, providedTags)) == null) continue;
                if (root == null) {
                    root = next;
                } else {
                    assert (parent != null);
                    parent.setNext(next);
                }
                parent = next;
            }
            if (!binding.isInstrumentedFull(providedTags, rootNode, instrumentedNode, sourceSection)) continue;
            if (TRACE) {
                InstrumentationHandler.trace("  Found binding %s, %s%n", binding.getFilter(), binding.getElement());
            }
            if ((next = probeNodeImpl.createEventChainCallback(frame, binding, rootNode, providedTags, instrumentedNode, sourceSection)) == null) continue;
            if (root == null) {
                root = next;
            } else {
                assert (parent != null);
                parent.setNext(next);
            }
            parent = next;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Lazy updated for %s%n", sourceSection);
        }
        return root;
    }

    public void onNodeInserted(RootNode rootNode, Node tree) {
        Node parentInstrumentable = tree;
        while (parentInstrumentable != null && parentInstrumentable.getParent() != null && !InstrumentationHandler.isInstrumentableNode(parentInstrumentable = parentInstrumentable.getParent())) {
        }
        assert (parentInstrumentable != null);
        if (!this.sourceSectionBindings.isEmpty() || !this.executionBindings.isEmpty()) {
            BindingsVisitorBuilder visitorBuilder = new BindingsVisitorBuilder();
            visitorBuilder.addNotifyLoadedOperationForAllBindings(VisitOperation.Scope.ALL);
            visitorBuilder.addInsertWrapperOperationForAllBindings(VisitOperation.Scope.ALL);
            this.visitRoot(rootNode, parentInstrumentable, visitorBuilder.buildVisitor(), true, false);
        }
    }

    private static void notifySourceBindingsLoaded(Collection<EventBinding.Source<?>> bindings, Source source) {
        for (EventBinding.Source<?> binding : bindings) {
            InstrumentationHandler.notifySourceBindingLoaded(binding, source);
        }
    }

    private static void notifySourceBindingLoaded(EventBinding.Source<?> binding, Source source) {
        if (!binding.isDisposed() && binding.isInstrumentedSource(source)) {
            try {
                ((LoadSourceListener)binding.getElement()).onLoad(new LoadSourceEvent(source));
            }
            catch (Throwable t) {
                if (binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
            }
        }
    }

    private static void notifySourceExecutedBindings(Collection<EventBinding.Source<?>> bindings, Source source) {
        for (EventBinding.Source<?> binding : bindings) {
            InstrumentationHandler.notifySourceExecutedBinding(binding, source);
        }
    }

    private static void notifySourceExecutedBinding(EventBinding.Source<?> binding, Source source) {
        if (!binding.isDisposed() && binding.isInstrumentedSource(source)) {
            try {
                ((ExecuteSourceListener)binding.getElement()).onExecute(new ExecuteSourceEvent(source));
            }
            catch (Throwable t) {
                if (binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(binding, "onExecute", t);
            }
        }
    }

    static void notifySourceSectionLoaded(EventBinding.Source<?> binding, Node node, SourceSection section) {
        if (section == null) {
            return;
        }
        LoadSourceSectionListener listener = (LoadSourceSectionListener)binding.getElement();
        try {
            listener.onLoad(new LoadSourceSectionEvent(section, node));
        }
        catch (Throwable t) {
            if (binding.isLanguageBinding()) {
                throw t;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
        }
    }

    private void addInstrumenter(Object key, AbstractInstrumenter instrumenter) throws AssertionError {
        AbstractInstrumenter previousKey = this.instrumenterMap.putIfAbsent(key, instrumenter);
        if (previousKey != null) {
            throw new AssertionError((Object)"Instrumenter already present.");
        }
    }

    private static Collection<EventBinding.Source<?>> filterBindingsForInstrumenter(Collection<EventBinding.Source<?>> bindings, AbstractInstrumenter instrumenter) {
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList newBindings = new ArrayList();
        for (EventBinding.Source<?> binding : bindings) {
            if (binding.getInstrumenter() != instrumenter) continue;
            newBindings.add(binding);
        }
        return newBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWrapper(Node instrumentableNode, SourceSection sourceSection) {
        Lock lock = InstrumentAccessor.nodesAccess().getLock(instrumentableNode);
        try {
            lock.lock();
            this.insertWrapperImpl(instrumentableNode, sourceSection);
        }
        finally {
            lock.unlock();
        }
    }

    private void insertWrapperImpl(Node node, SourceSection sourceSection) {
        InstrumentableNode.WrapperNode wrapper;
        Node parent = node.getParent();
        if (parent instanceof InstrumentableNode.WrapperNode) {
            InstrumentationHandler.invalidateWrapperImpl((InstrumentableNode.WrapperNode)((Object)parent), node);
            return;
        }
        ProbeNode probe = new ProbeNode(this, sourceSection);
        if (node instanceof InstrumentableNode) {
            try {
                wrapper = ((InstrumentableNode)((Object)node)).createWrapper(probe);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create wrapper of " + node, e);
            }
        } else {
            throw new AssertionError();
        }
        Node wrapperNode = InstrumentationHandler.getWrapperNodeChecked(wrapper, node, parent);
        node.replace(wrapperNode, "Insert instrumentation wrapper node.");
        assert (probe.getContext().validEventContext());
    }

    private static Node getWrapperNodeChecked(Object wrapper, Node node, Node parent) {
        if (wrapper == null) {
            throw new IllegalStateException("No wrapper returned for " + node + " of class " + node.getClass().getName());
        }
        if (!(wrapper instanceof Node)) {
            throw new IllegalStateException(String.format("Implementation of %s must be a subclass of %s.", wrapper.getClass().getName(), Node.class.getSimpleName()));
        }
        Node wrapperNode = (Node)wrapper;
        if (wrapperNode.getParent() != null) {
            throw new IllegalStateException(String.format("Instance of provided wrapper %s is already adopted by another parent: %s", wrapper.getClass().getName(), wrapperNode.getParent().getClass().getName()));
        }
        if (parent == null) {
            throw new IllegalStateException(String.format("Instance of instrumentable node %s is not adopted by a parent.", node.getClass().getName()));
        }
        if (!NodeUtil.isReplacementSafe(parent, node, wrapperNode)) {
            throw new IllegalStateException(String.format("WrapperNode implementation %s cannot be safely replaced in parent node class %s.", wrapperNode.getClass().getName(), parent.getClass().getName()));
        }
        return wrapperNode;
    }

    private <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(AbstractInstrumenter instrumenter, SourceSectionFilter filter, SourceSectionFilter inputFilter, T factory) {
        return this.addExecutionBinding(new EventBinding.Source<T>(instrumenter, filter, inputFilter, factory, true));
    }

    private <T extends ExecutionEventListener> EventBinding<T> attachListener(AbstractInstrumenter instrumenter, SourceSectionFilter filter, SourceSectionFilter inputFilter, T listener) {
        return this.addExecutionBinding(new EventBinding.Source<T>(instrumenter, filter, inputFilter, listener, true));
    }

    private <T extends LoadSourceListener> EventBinding<T> attachSourceListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private <T> EventBinding<T> attachSourceSectionListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceSectionBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private void visitLoadedSourceSections(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, LoadSourceSectionListener listener) {
        this.visitLoadedSourceSections(new EventBinding.Source<LoadSourceSectionListener>(abstractInstrumenter, filter, null, listener, false));
    }

    private <T> EventBinding<T> attachExecuteSourceListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceExecutionBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private <T extends OutputStream> EventBinding<T> attachOutputConsumer(AbstractInstrumenter instrumenter, T stream, boolean errorOutput) {
        return this.addOutputBinding(new EventBinding<T>(instrumenter, stream), errorOutput);
    }

    private <T extends AllocationListener> EventBinding<T> attachAllocationListener(AbstractInstrumenter instrumenter, AllocationEventFilter filter, T listener) {
        return this.addAllocationBinding(new EventBinding.Allocation<T>(instrumenter, filter, listener));
    }

    private <T extends ContextsListener> EventBinding<T> attachContextsListener(AbstractInstrumenter instrumenter, T listener, boolean includeActiveContexts) {
        assert (listener != null);
        return this.addContextsBinding(new EventBinding<T>(instrumenter, listener), includeActiveContexts);
    }

    private <T extends ThreadsListener> EventBinding<T> attachThreadsListener(AbstractInstrumenter instrumenter, T listener, boolean includeStartedThreads) {
        assert (listener != null);
        return this.addThreadsBinding(new EventBinding<T>(instrumenter, listener), includeStartedThreads);
    }

    boolean hasContextBindings() {
        return !this.contextsBindings.isEmpty();
    }

    void notifyContextCreated(TruffleContext context) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onContextCreated(context);
        }
    }

    void notifyContextClosed(TruffleContext context) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onContextClosed(context);
        }
    }

    void notifyLanguageContextCreated(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextCreated(context, language);
        }
    }

    void notifyLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextInitialized(context, language);
        }
    }

    void notifyLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextFinalized(context, language);
        }
    }

    void notifyLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextDisposed(context, language);
        }
    }

    void notifyThreadStarted(TruffleContext context, Thread thread) {
        for (EventBinding<? extends ThreadsListener> binding : this.threadsBindings) {
            binding.getElement().onThreadInitialized(context, thread);
        }
    }

    void notifyThreadFinished(TruffleContext context, Thread thread) {
        for (EventBinding<? extends ThreadsListener> binding : this.threadsBindings) {
            binding.getElement().onThreadDisposed(context, thread);
        }
    }

    Set<Class<?>> getProvidedTags(TruffleLanguage<?> lang) {
        if (lang == null) {
            return Collections.emptySet();
        }
        Class<?> languageClass = lang.getClass();
        Set<Class<Object>> tags = this.cachedProvidedTags.get(languageClass);
        if (tags == null) {
            ProvidedTags languageTags = languageClass.getAnnotation(ProvidedTags.class);
            List languageTagsList = languageTags != null ? Arrays.asList(languageTags.value()) : Collections.emptyList();
            tags = Collections.unmodifiableSet(new HashSet(languageTagsList));
            this.cachedProvidedTags.put(languageClass, tags);
        }
        return tags;
    }

    Set<Class<?>> getProvidedTags(Node root) {
        return this.getProvidedTags(InstrumentAccessor.nodesAccess().getLanguage(root.getRootNode()));
    }

    static boolean isInstrumentableNode(Node node) {
        if (node instanceof InstrumentableNode.WrapperNode) {
            return false;
        }
        if (node instanceof InstrumentableNode) {
            return ((InstrumentableNode)((Object)node)).isInstrumentable();
        }
        return false;
    }

    static void trace(String message, Object ... args) {
        PrintStream out = System.out;
        out.printf(message, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitRoot(RootNode root, Node node, AbstractNodeVisitor visitor, boolean forceRootBitComputation, boolean firstExecution) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visit root %s for %s%n", root.toString(), visitor);
        }
        visitor.instrumentationHandler = this;
        visitor.firstExecution = firstExecution;
        visitor.root = root;
        visitor.providedTags = this.getProvidedTags(root);
        visitor.materializeTags = visitor.materializeLimitedTags == null ? visitor.providedTags : visitor.materializeLimitedTags;
        visitor.rootSourceSection = root.getSourceSection();
        visitor.rootBits = RootNodeBits.get(visitor.root);
        if (visitor.shouldVisit() || forceRootBitComputation) {
            if (forceRootBitComputation) {
                visitor.computingRootNodeBits = RootNodeBits.isUninitialized(visitor.rootBits) ? RootNodeBits.getAll() : visitor.rootBits;
            } else if (RootNodeBits.isUninitialized(visitor.rootBits)) {
                visitor.computingRootNodeBits = RootNodeBits.getAll();
            }
            if (TRACE) {
                InstrumentationHandler.trace("BEGIN: Traverse root %s for %s%n", root.toString(), visitor);
            }
            Lock lock = InstrumentAccessor.nodesAccess().getLock(node);
            try {
                lock.lock();
                visitor.visit(node);
            }
            finally {
                lock.unlock();
            }
            if (TRACE) {
                InstrumentationHandler.trace("END: Traverse root %s for %s%n", root.toString(), visitor);
            }
            if (!RootNodeBits.isUninitialized(visitor.computingRootNodeBits)) {
                RootNodeBits.set(visitor.root, visitor.computingRootNodeBits);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Visited root %s for %s%n", root.toString(), visitor);
        }
    }

    static void removeWrapper(ProbeNode node) {
        if (TRACE) {
            InstrumentationHandler.trace("Remove wrapper for %s%n", node.getContext().getInstrumentedSourceSection());
        }
        InstrumentableNode.WrapperNode wrapperNode = node.findWrapper();
        ((Node)((Object)wrapperNode)).replace(wrapperNode.getDelegateNode());
    }

    private static void invalidateWrapper(Node node) {
        Node parent = node.getParent();
        if (!(parent instanceof InstrumentableNode.WrapperNode)) {
            return;
        }
        InstrumentationHandler.invalidateWrapperImpl((InstrumentableNode.WrapperNode)((Object)parent), node);
    }

    private static void invalidateWrapperImpl(InstrumentableNode.WrapperNode parent, Node node) {
        ProbeNode probeNode = parent.getProbeNode();
        if (TRACE) {
            SourceSection section = probeNode.getContext().getInstrumentedSourceSection();
            InstrumentationHandler.trace("Invalidate wrapper for %s, section %s %n", node, section);
        }
        if (probeNode != null) {
            probeNode.invalidate();
        }
    }

    static boolean hasTagImpl(Set<Class<?>> providedTags, Node node, Class<?> tag) {
        if (providedTags.contains(tag)) {
            if (node instanceof InstrumentableNode) {
                return ((InstrumentableNode)((Object)node)).hasTag(tag);
            }
            return false;
        }
        return false;
    }

    <T> T lookup(Object key, Class<T> type) {
        AbstractInstrumenter value = this.instrumenterMap.get(key);
        return value == null ? null : (T)value.lookup(this, type);
    }

    AllocationReporter getAllocationReporter(LanguageInfo info) {
        AllocationReporter allocationReporter = new AllocationReporter(info);
        this.allocationReporters.add(allocationReporter);
        for (EventBinding.Allocation<? extends AllocationListener> binding : this.allocationBindings) {
            if (!binding.getAllocationFilter().contains(info)) continue;
            allocationReporter.addListener((AllocationListener)binding.getElement());
        }
        return allocationReporter;
    }

    void patch(DispatchOutputStream newOut, DispatchOutputStream newErr, InputStream newIn) {
        this.out = newOut;
        this.err = newErr;
        this.in = newIn;
    }

    static void failInstrumentInitialization(TruffleInstrument.Env env, String message, Throwable t) {
        Exception exception = new Exception(message, t);
        PrintStream stream = new PrintStream(env.err());
        exception.printStackTrace(stream);
    }

    private static InstrumentableNode.WrapperNode getWrapperNode(Node node) {
        Node parent = node.getParent();
        return parent instanceof InstrumentableNode.WrapperNode ? (InstrumentableNode.WrapperNode)((Object)parent) : null;
    }

    private static void traceFilterCheck(String result, Node instrumentableNode, SourceSection sourceSection) {
        InstrumentationHandler.trace("  Filter %4s node:%s section:%s %n", result, instrumentableNode, sourceSection);
    }

    private static final class SourceList {
        private final Collection<Source> list = new WeakAsyncList<Source>(16);
        private boolean complete = false;

        private SourceList() {
        }

        synchronized Collection<Source> getCompleteList() {
            while (!this.complete) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            return this.list;
        }

        void add(Source source) {
            this.list.add(source);
        }

        synchronized void notifyComplete() {
            this.complete = true;
            this.notifyAll();
        }

        private synchronized boolean addIfIncomplete(Source[] sources) {
            if (!this.complete) {
                for (Source source : sources) {
                    if (this.list.contains(source)) continue;
                    this.list.add(source);
                }
                return true;
            }
            return false;
        }

        static /* synthetic */ boolean access$200(SourceList x0, Source[] x1) {
            return x0.addIfIncomplete(x1);
        }
    }

    private static final class WeakAsyncList<T>
    extends AbstractAsyncCollection<WeakReference<T>, T> {
        WeakAsyncList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected WeakReference<T> wrap(T element) {
            return new WeakReference<T>(element);
        }

        @Override
        protected T unwrap(WeakReference<T> element) {
            return element.get();
        }
    }

    private static final class EventBindingList<EB extends EventBinding<?>>
    extends AbstractAsyncCollection<EB, EB> {
        EventBindingList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected EB wrap(EB element) {
            return element;
        }

        @Override
        protected EB unwrap(EB element) {
            if (((EventBinding)element).isDisposed()) {
                return null;
            }
            return element;
        }
    }

    private static abstract class AbstractAsyncCollection<T, R>
    extends AbstractCollection<R> {
        private volatile AtomicReferenceArray<T> values;
        private int nextInsertionIndex;

        AbstractAsyncCollection(int initialCapacity) {
            if (initialCapacity <= 0) {
                throw new IllegalArgumentException("Invalid initial capacity " + initialCapacity);
            }
            this.values = new AtomicReferenceArray(initialCapacity);
        }

        @Override
        public final synchronized boolean add(R reference) {
            T wrappedElement = this.wrap(reference);
            if (wrappedElement == null) {
                throw new NullPointerException();
            }
            if (this.nextInsertionIndex >= this.values.length()) {
                this.compact();
            }
            this.values.set(this.nextInsertionIndex++, wrappedElement);
            return true;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isEmpty() {
            return this.values.get(0) == null;
        }

        protected abstract T wrap(R var1);

        protected abstract R unwrap(T var1);

        private void compact() {
            T ref;
            T ref2;
            AtomicReferenceArray<T> localValues = this.values;
            int liveElements = 0;
            for (int i = 0; i < localValues.length() && (ref2 = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref2) == null) continue;
                ++liveElements;
            }
            AtomicReferenceArray<T> newValues = new AtomicReferenceArray<T>(Math.max(liveElements * 2, 8));
            int index = 0;
            for (int i = 0; i < localValues.length() && (ref = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref) == null) continue;
                newValues.set(index++, ref);
            }
            this.nextInsertionIndex = index;
            this.values = newValues;
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final AtomicReferenceArray<T> values;
                private int index;
                private R queuedNext;
                {
                    this.values = values;
                }

                @Override
                public boolean hasNext() {
                    Object next = this.queuedNext;
                    if (next == null) {
                        this.queuedNext = next = this.queueNext();
                    }
                    return next != null;
                }

                private R queueNext() {
                    Object localValue;
                    Object alive;
                    int localIndex = this.index;
                    AtomicReferenceArray array = this.values;
                    do {
                        if (localIndex >= array.length()) {
                            return null;
                        }
                        localValue = array.get(localIndex);
                        if (localValue == null) {
                            return null;
                        }
                        ++localIndex;
                    } while ((alive = this.unwrap(localValue)) == null);
                    this.index = localIndex;
                    return alive;
                }

                @Override
                public R next() {
                    Object next = this.queuedNext;
                    if (next == null && (next = this.queueNext()) == null) {
                        throw new NoSuchElementException();
                    }
                    this.queuedNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    abstract class AbstractInstrumenter
    extends Instrumenter {
        AbstractInstrumenter() {
        }

        abstract void doFinalize();

        abstract void dispose();

        abstract <T> T lookup(InstrumentationHandler var1, Class<T> var2);

        public void disposeBinding(EventBinding<?> binding) {
            InstrumentationHandler.this.disposeBinding(binding);
        }

        abstract boolean isInstrumentableRoot(RootNode var1);

        abstract boolean isInstrumentableSource(Source var1);

        final Set<Class<?>> queryTagsImpl(Node node, LanguageInfo onlyLanguage) {
            Objects.requireNonNull(node);
            if (!InstrumentationHandler.isInstrumentableNode(node)) {
                return Collections.emptySet();
            }
            RootNode root = node.getRootNode();
            if (root == null) {
                return Collections.emptySet();
            }
            if (onlyLanguage != null && root.getLanguageInfo() != onlyLanguage) {
                throw new IllegalArgumentException("The language instrumenter cannot query tags of nodes of other languages.");
            }
            Set<Class<?>> providedTags = InstrumentationHandler.this.getProvidedTags(root);
            if (providedTags.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet tags = new HashSet();
            for (Class<?> providedTag : providedTags) {
                if (!InstrumentationHandler.hasTagImpl(providedTags, node, providedTag)) continue;
                tags.add(providedTag);
            }
            return Collections.unmodifiableSet(tags);
        }

        @Override
        public final ExecutionEventNode lookupExecutionEventNode(Node node, EventBinding<?> binding) {
            if (!InstrumentationHandler.isInstrumentableNode(node)) {
                return null;
            }
            Node p = node.getParent();
            if (p instanceof InstrumentableNode.WrapperNode) {
                InstrumentableNode.WrapperNode w = (InstrumentableNode.WrapperNode)((Object)p);
                return w.getProbeNode().lookupExecutionEventNode(binding);
            }
            return null;
        }

        @Override
        public <T extends ExecutionEventNodeFactory> EventBinding<T> attachExecutionEventFactory(SourceSectionFilter filter, SourceSectionFilter inputFilter, T factory) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachFactory(this, filter, inputFilter, factory);
        }

        @Override
        public <T extends ExecutionEventListener> EventBinding<T> attachExecutionEventListener(SourceSectionFilter filter, SourceSectionFilter inputFilter, T listener) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachListener(this, filter, inputFilter, listener);
        }

        @Override
        public <T extends LoadSourceListener> EventBinding<T> attachLoadSourceListener(SourceSectionFilter filter, T listener, boolean includeExistingSources) {
            this.verifySourceOnly(filter);
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceListener(this, filter, listener, includeExistingSources);
        }

        @Override
        public <T extends LoadSourceListener> EventBinding<T> attachLoadSourceListener(SourceFilter filter, T listener, boolean notifyLoaded) {
            SourceSectionFilter sectionsFilter = SourceSectionFilter.newBuilder().sourceFilter(filter).build();
            return this.attachLoadSourceListener(sectionsFilter, listener, notifyLoaded);
        }

        @Override
        public <T extends LoadSourceSectionListener> EventBinding<T> attachLoadSourceSectionListener(SourceSectionFilter filter, T listener, boolean notifyLoaded) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceSectionListener(this, filter, listener, notifyLoaded);
        }

        @Override
        public void visitLoadedSourceSections(SourceSectionFilter filter, LoadSourceSectionListener listener) {
            this.verifyFilter(filter);
            InstrumentationHandler.this.visitLoadedSourceSections(this, filter, listener);
        }

        @Override
        public <T extends ExecuteSourceListener> EventBinding<T> attachExecuteSourceListener(SourceFilter filter, T listener, boolean notifyLoaded) {
            SourceSectionFilter sectionsFilter = SourceSectionFilter.newBuilder().sourceFilter(filter).build();
            return InstrumentationHandler.this.attachExecuteSourceListener(this, sectionsFilter, listener, notifyLoaded);
        }

        @Override
        public <T extends AllocationListener> EventBinding<T> attachAllocationListener(AllocationEventFilter filter, T listener) {
            return InstrumentationHandler.this.attachAllocationListener(this, filter, listener);
        }

        @Override
        public <T extends OutputStream> EventBinding<T> attachOutConsumer(T stream) {
            return InstrumentationHandler.this.attachOutputConsumer(this, stream, false);
        }

        @Override
        public <T extends OutputStream> EventBinding<T> attachErrConsumer(T stream) {
            return InstrumentationHandler.this.attachOutputConsumer(this, stream, true);
        }

        private void verifySourceOnly(SourceSectionFilter filter) {
            if (!filter.isSourceOnly()) {
                throw new IllegalArgumentException(String.format("The attached filter %s uses filters that require source sections to verifiy. Source listeners can only use filter critera based on Source objects like mimeTypeIs or sourceIs.", filter));
            }
        }

        abstract void verifyFilter(SourceSectionFilter var1);
    }

    final class LanguageClientInstrumenter<T>
    extends AbstractInstrumenter {
        private final LanguageInfo languageInfo;
        private final TruffleLanguage<?> language;

        LanguageClientInstrumenter(TruffleLanguage<?> language) {
            this.language = language;
            this.languageInfo = InstrumentAccessor.langAccess().getLanguageInfo(language);
        }

        @Override
        boolean isInstrumentableSource(Source source) {
            String mimeType = source.getMimeType();
            if (mimeType == null) {
                return false;
            }
            return this.languageInfo.getMimeTypes().contains(mimeType);
        }

        @Override
        boolean isInstrumentableRoot(RootNode node) {
            LanguageInfo langInfo = node.getLanguageInfo();
            if (langInfo == null) {
                return false;
            }
            return langInfo == this.languageInfo;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, this.languageInfo);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
            Set<Class<?>> referencedTags;
            Set<Class<Class<?>>> providedTags = InstrumentationHandler.this.getProvidedTags(this.language);
            if (!providedTags.containsAll(referencedTags = filter.getReferencedTags())) {
                HashSet missingTags = new HashSet(referencedTags);
                missingTags.removeAll(providedTags);
                LinkedHashSet allTags = new LinkedHashSet(providedTags);
                allTags.addAll(missingTags);
                StringBuilder builder = new StringBuilder("{");
                String sep = "";
                for (Class clazz : allTags) {
                    builder.append(sep);
                    builder.append(clazz.getSimpleName());
                    sep = ", ";
                }
                builder.append("}");
                throw new IllegalArgumentException(String.format("The attached filter %s references the following tags %s which are not declared as provided by the language. To fix this annotate the language class %s with @%s(%s).", filter, missingTags, this.language.getClass().getName(), ProvidedTags.class.getSimpleName(), builder));
            }
        }

        public <S extends ContextsListener> EventBinding<S> attachContextsListener(S listener, boolean includeActiveContexts) {
            throw new UnsupportedOperationException("Not supported in language instrumenter.");
        }

        public <S extends ThreadsListener> EventBinding<S> attachThreadsListener(S listener, boolean includeStartedThreads) {
            throw new UnsupportedOperationException("Not supported in language instrumenter.");
        }

        @Override
        void doFinalize() {
        }

        @Override
        void dispose() {
        }

        <S> S lookup(InstrumentationHandler handler, Class<S> type) {
            return null;
        }
    }

    final class EngineInstrumenter
    extends AbstractInstrumenter {
        EngineInstrumenter() {
        }

        @Override
        void doFinalize() {
        }

        @Override
        void dispose() {
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            return null;
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        boolean isInstrumentableSource(Source source) {
            return true;
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        public <T extends ContextsListener> EventBinding<T> attachContextsListener(T listener, boolean includeActiveContexts) {
            throw new UnsupportedOperationException("Not supported in engine instrumenter.");
        }

        @Override
        public <T extends ThreadsListener> EventBinding<T> attachThreadsListener(T listener, boolean includeStartedThreads) {
            throw new UnsupportedOperationException("Not supported in engine instrumenter.");
        }
    }

    final class InstrumentClientInstrumenter
    extends AbstractInstrumenter {
        private final String instrumentClassName;
        private Object[] services;
        TruffleInstrument instrument;
        private final TruffleInstrument.Env env;

        InstrumentClientInstrumenter(TruffleInstrument.Env env, String instrumentClassName) {
            this.instrumentClassName = instrumentClassName;
            this.env = env;
        }

        @Override
        boolean isInstrumentableSource(Source source) {
            return true;
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        String getInstrumentClassName() {
            return this.instrumentClassName;
        }

        TruffleInstrument.Env getEnv() {
            return this.env;
        }

        void create(String[] expectedServices) {
            if (TRACE) {
                InstrumentationHandler.trace("Create instrument %s class %s %n", this.instrument, this.instrumentClassName);
            }
            this.services = this.env.onCreate(this.instrument);
            if (expectedServices != null && !TruffleOptions.AOT) {
                this.checkServices(expectedServices);
            }
            if (TRACE) {
                InstrumentationHandler.trace("Created instrument %s class %s %n", this.instrument, this.instrumentClassName);
            }
        }

        private boolean checkServices(String[] expectedServices) {
            block0: for (String name : expectedServices) {
                for (Object obj : this.services) {
                    if (this.findType(name, obj.getClass())) continue block0;
                }
                InstrumentationHandler.failInstrumentInitialization(this.env, String.format("%s declares service %s but doesn't register it", this.instrumentClassName, name), null);
            }
            return true;
        }

        private boolean findType(String name, Class<?> type) {
            if (type == null) {
                return false;
            }
            if (type.getName().equals(name) || type.getCanonicalName() != null && type.getCanonicalName().equals(name)) {
                return true;
            }
            if (this.findType(name, type.getSuperclass())) {
                return true;
            }
            for (Class<?> inter : type.getInterfaces()) {
                if (!this.findType(name, inter)) continue;
                return true;
            }
            return false;
        }

        boolean isInitialized() {
            return this.instrument != null;
        }

        TruffleInstrument getInstrument() {
            return this.instrument;
        }

        @Override
        public <T extends ContextsListener> EventBinding<T> attachContextsListener(T listener, boolean includeActiveContexts) {
            return InstrumentationHandler.this.attachContextsListener(this, listener, includeActiveContexts);
        }

        @Override
        public <T extends ThreadsListener> EventBinding<T> attachThreadsListener(T listener, boolean includeStartedThreads) {
            return InstrumentationHandler.this.attachThreadsListener(this, listener, includeStartedThreads);
        }

        @Override
        void doFinalize() {
            this.instrument.onFinalize(this.env);
        }

        @Override
        void dispose() {
            this.instrument.onDispose(this.env);
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            if (this.services != null) {
                for (Object service : this.services) {
                    if (!type.isInstance(service)) continue;
                    return type.cast(service);
                }
            }
            return null;
        }
    }

    private static class BindingsVisitor
    extends AbstractNodeVisitor {
        private final List<VisitOperation> operations;
        private final boolean singleBindingOptimization;

        BindingsVisitor(boolean shouldMaterializeSyntaxNodes, List<VisitOperation> operations) {
            super(shouldMaterializeSyntaxNodes);
            this.operations = operations;
            int singleBindingOperations = 0;
            int multiBindingOriginalTreeOperations = 0;
            for (VisitOperation operation : operations) {
                if (operation.singleBindingOperation) {
                    ++singleBindingOperations;
                    continue;
                }
                if (operation.scope != VisitOperation.Scope.ALL && operation.scope != VisitOperation.Scope.ONLY_ORIGINAL) continue;
                ++multiBindingOriginalTreeOperations;
            }
            this.singleBindingOptimization = operations.size() == 1 && singleBindingOperations == 1 || singleBindingOperations == 1 && multiBindingOriginalTreeOperations == 0;
            HashSet compoundTags = null;
            block1: for (VisitOperation operation : operations) {
                for (EventBinding.Source sourceBinding : operation.bindings) {
                    Set<Class<?>> limitedTags = sourceBinding.getLimitedTags();
                    if (limitedTags == null) {
                        compoundTags = null;
                        continue block1;
                    }
                    if (compoundTags == null) {
                        compoundTags = new HashSet();
                    }
                    compoundTags.addAll(limitedTags);
                }
            }
            this.materializeLimitedTags = compoundTags != null ? Collections.unmodifiableSet(compoundTags) : null;
        }

        @Override
        boolean shouldVisit() {
            if (this.operations.isEmpty()) {
                return false;
            }
            RootNode localRoot = this.root;
            SourceSection localRootSourceSection = this.rootSourceSection;
            int localRootBits = this.rootBits;
            for (VisitOperation operation : this.operations) {
                if (this.singleBindingOptimization && !operation.singleBindingOperation) continue;
                for (EventBinding.Source binding : operation.bindings) {
                    if (!binding.isInstrumentedRoot(this.providedTags, localRoot, localRootSourceSection, localRootBits)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean shouldPerformForBinding(VisitOperation operation, EventBinding.Source<?> binding, Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            if (this.singleBindingOptimization && operation.singleBindingOperation) {
                return binding.isInstrumentedLeaf(this.providedTags, instrumentableNode, sourceSection) || binding.isChildInstrumentedLeaf(this.providedTags, this.root, parentInstrumentable, parentSourceSection, instrumentableNode, sourceSection);
            }
            return binding.isInstrumentedFull(this.providedTags, this.root, instrumentableNode, sourceSection) || binding.isChildInstrumentedFull(this.providedTags, this.root, parentInstrumentable, parentSourceSection, instrumentableNode, sourceSection);
        }

        @Override
        protected void visitInstrumentable(Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            block0: for (VisitOperation operation : this.operations) {
                if (operation.scope != VisitOperation.Scope.ALL && (this.visitingMaterialized || operation.scope != VisitOperation.Scope.ONLY_ORIGINAL) && (!this.visitingMaterialized || operation.scope != VisitOperation.Scope.ONLY_MATERIALIZED)) continue;
                for (EventBinding.Source binding : operation.bindings) {
                    if (this.shouldPerformForBinding(operation, binding, parentInstrumentable, parentSourceSection, instrumentableNode, sourceSection)) {
                        if (TRACE) {
                            InstrumentationHandler.traceFilterCheck("hit", instrumentableNode, sourceSection);
                        }
                        operation.perform(binding, instrumentableNode, sourceSection);
                        if (operation.performForEachBinding) continue;
                        continue block0;
                    }
                    if (!TRACE) continue;
                    InstrumentationHandler.traceFilterCheck("miss", instrumentableNode, sourceSection);
                }
            }
        }
    }

    private static abstract class AbstractNodeVisitor
    implements NodeVisitor {
        InstrumentationHandler instrumentationHandler;
        RootNode root;
        SourceSection rootSourceSection;
        Set<Class<?>> providedTags;
        Set<?> materializeLimitedTags;
        boolean firstExecution = false;
        int rootBits;
        int computingRootNodeBits;
        boolean visitingRetiredNodes;
        boolean visitingMaterialized;
        private final boolean shouldMaterializeSyntaxNodes;
        Set<Class<? extends Tag>> materializeTags;
        private Node savedParent;
        private SourceSection savedParentSourceSection;

        AbstractNodeVisitor(boolean shouldMaterializeSyntaxNodes) {
            this.shouldMaterializeSyntaxNodes = shouldMaterializeSyntaxNodes;
        }

        abstract boolean shouldVisit();

        private void computeRootBits(SourceSection sourceSection) {
            int bits = this.computingRootNodeBits;
            if (RootNodeBits.isUninitialized(bits)) {
                return;
            }
            if (sourceSection != null) {
                if (RootNodeBits.isNoSourceSection(bits)) {
                    bits = RootNodeBits.setHasSourceSection(bits);
                }
                if (this.rootSourceSection != null) {
                    if (RootNodeBits.isSourceSectionsHierachical(bits) && (sourceSection.getCharIndex() < this.rootSourceSection.getCharIndex() || sourceSection.getCharEndIndex() > this.rootSourceSection.getCharEndIndex())) {
                        bits = RootNodeBits.setSourceSectionsUnstructured(bits);
                    }
                    if (RootNodeBits.isSameSource(bits) && this.rootSourceSection.getSource() != sourceSection.getSource()) {
                        bits = RootNodeBits.setHasDifferentSource(bits);
                    }
                } else {
                    bits = RootNodeBits.setSourceSectionsUnstructured(bits);
                    bits = RootNodeBits.setHasDifferentSource(bits);
                }
            }
            this.computingRootNodeBits = bits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean visit(Node originalNode) {
            Node node = originalNode;
            SourceSection sourceSection = node.getSourceSection();
            boolean instrumentable = InstrumentationHandler.isInstrumentableNode(node);
            Node previousParent = null;
            SourceSection previousParentSourceSection = null;
            if (instrumentable) {
                this.computeRootBits(sourceSection);
                boolean hasRetiredNodes = this.visitPreviouslyRetiredNodes(node);
                if (!this.visitingRetiredNodes) {
                    if (this.saveAndVisitNewlyRetiredNode(node = this.materialize(node, sourceSection, originalNode), sourceSection, originalNode)) {
                        hasRetiredNodes = true;
                    }
                    if (!hasRetiredNodes) {
                        AbstractNodeVisitor.clearRetiredNodeReference(node);
                    }
                }
                this.visitInstrumentable(this.savedParent, this.savedParentSourceSection, node, sourceSection);
                previousParent = this.savedParent;
                previousParentSourceSection = this.savedParentSourceSection;
                this.savedParent = node;
                this.savedParentSourceSection = sourceSection;
            }
            boolean wasVisitingMaterialized = this.visitingMaterialized;
            if (node != originalNode) {
                this.visitingMaterialized = true;
            }
            try {
                NodeUtil.forEachChild(node, this);
            }
            finally {
                this.visitingMaterialized = wasVisitingMaterialized;
                if (instrumentable) {
                    this.savedParent = previousParent;
                    this.savedParentSourceSection = previousParentSourceSection;
                }
            }
            return true;
        }

        private Node materialize(Node node, SourceSection sourceSection, Node originalNode) {
            Node materializedNode = this.materializeSyntaxNodes(node, sourceSection);
            assert (!this.visitingMaterialized || materializedNode == originalNode) : "New tree should be fully materialized!";
            assert (materializedNode == this.materializeSyntaxNodes(materializedNode, sourceSection)) : "Node must not be materialized multiple times for the same set of tags!";
            return materializedNode;
        }

        private boolean saveAndVisitNewlyRetiredNode(Node node, SourceSection sourceSection, Node originalNode) {
            if (!this.firstExecution && node != originalNode) {
                assert (this.materializeTags != null) : "Materialize tags must not be null when materialization happened.";
                InstrumentableNode.WrapperNode wrapperNode = InstrumentationHandler.getWrapperNode(node);
                if (wrapperNode == null) {
                    this.instrumentationHandler.insertWrapper(node, sourceSection);
                }
                wrapperNode = InstrumentationHandler.getWrapperNode(node);
                assert (wrapperNode != null) : "Node must have an instrumentation wrapper at this point!";
                wrapperNode.getProbeNode().setRetiredNode(originalNode, this.materializeTags);
                this.visitRetiredNodes(originalNode);
                return true;
            }
            return false;
        }

        private static void clearRetiredNodeReference(Node node) {
            InstrumentableNode.WrapperNode wrapperNode = InstrumentationHandler.getWrapperNode(node);
            if (wrapperNode != null) {
                wrapperNode.getProbeNode().clearRetiredNodeReference();
                InstrumentationHandler.invalidateWrapperImpl(wrapperNode, node);
            }
        }

        private boolean visitPreviouslyRetiredNodes(Node node) {
            if (!this.firstExecution) {
                ProbeNode.RetiredNodeReference retiredNodeReference;
                InstrumentableNode.WrapperNode wrapperNode = InstrumentationHandler.getWrapperNode(node);
                ProbeNode.RetiredNodeReference retiredNodeReference2 = retiredNodeReference = wrapperNode != null ? wrapperNode.getProbeNode().getRetiredNodeReference() : null;
                if (retiredNodeReference != null) {
                    boolean hasRetiredNodes = false;
                    while (retiredNodeReference != null) {
                        Node nodeRefNode = retiredNodeReference.getNode();
                        if (nodeRefNode != null) {
                            hasRetiredNodes = true;
                            this.visitRetiredNodes(nodeRefNode);
                        }
                        retiredNodeReference = retiredNodeReference.next;
                    }
                    return hasRetiredNodes;
                }
            }
            return false;
        }

        private void visitRetiredNodes(Node retiredSubtreeRoot) {
            boolean wasVisitingRetiredNodes = this.visitingRetiredNodes;
            this.visitingRetiredNodes = true;
            try {
                NodeUtil.forEachChild(retiredSubtreeRoot, this);
            }
            finally {
                this.visitingRetiredNodes = wasVisitingRetiredNodes;
            }
        }

        private Node materializeSyntaxNodes(Node instrumentableNode, SourceSection sourceSection) {
            if (!this.shouldMaterializeSyntaxNodes) {
                return instrumentableNode;
            }
            if (instrumentableNode instanceof InstrumentableNode) {
                assert (this.materializeTags != null) : "Materialize tags must not be null before materialization.";
                InstrumentableNode currentNode = (InstrumentableNode)((Object)instrumentableNode);
                assert (currentNode.isInstrumentable());
                InstrumentableNode materializedNode = currentNode.materializeInstrumentableNodes(this.materializeTags);
                if (currentNode != materializedNode) {
                    if (!(materializedNode instanceof Node)) {
                        throw new IllegalStateException("The returned materialized syntax node is not a Truffle Node.");
                    }
                    if (((Node)((Object)materializedNode)).getParent() != null) {
                        throw new IllegalStateException("The returned materialized syntax node is already adopted.");
                    }
                    SourceSection newSourceSection = ((Node)((Object)materializedNode)).getSourceSection();
                    if (!Objects.equals(sourceSection, newSourceSection)) {
                        throw new IllegalStateException(String.format("The source section of the materialized syntax node must match the source section of the original node. %s != %s.", sourceSection, newSourceSection));
                    }
                    Node currentParent = ((Node)((Object)currentNode)).getParent();
                    if (currentParent instanceof InstrumentableNode.WrapperNode && !NodeUtil.isReplacementSafe(currentParent, instrumentableNode, (Node)((Object)materializedNode))) {
                        ProbeNode probe = ((InstrumentableNode.WrapperNode)((Object)currentParent)).getProbeNode();
                        InstrumentableNode.WrapperNode wrapper = materializedNode.createWrapper(probe);
                        Node wrapperNode = InstrumentationHandler.getWrapperNodeChecked(wrapper, (Node)((Object)materializedNode), currentParent.getParent());
                        currentParent.replace(wrapperNode, "Insert instrumentation wrapper node.");
                        return (Node)((Object)materializedNode);
                    }
                    return ((Node)((Object)currentNode)).replace((Node)((Object)materializedNode));
                }
            }
            return instrumentableNode;
        }

        protected abstract void visitInstrumentable(Node var1, SourceSection var2, Node var3, SourceSection var4);
    }

    private class BindingsVisitorBuilder {
        List<VisitOperation> operations = new ArrayList<VisitOperation>();
        boolean shouldMaterializeSyntaxNodes;

        private BindingsVisitorBuilder() {
        }

        BindingsVisitorBuilder addNotifyLoadedOperationForAllBindings(VisitOperation.Scope scope) {
            this.operations.add(new NotifyLoadedOperation(scope, InstrumentationHandler.this.sourceSectionBindings));
            this.shouldMaterializeSyntaxNodes = true;
            return this;
        }

        BindingsVisitorBuilder addNotifyLoadedOperationForBinding(VisitOperation.Scope scope, EventBinding.Source<?> binding) {
            this.operations.add(new NotifyLoadedOperation(scope, binding));
            this.shouldMaterializeSyntaxNodes = true;
            return this;
        }

        BindingsVisitorBuilder addInsertWrapperOperationForAllBindings(VisitOperation.Scope scope) {
            this.operations.add(new InsertWrapperOperation(scope, InstrumentationHandler.this.executionBindings));
            this.shouldMaterializeSyntaxNodes = true;
            return this;
        }

        BindingsVisitorBuilder addInsertWrapperOperationForBinding(VisitOperation.Scope scope, EventBinding.Source<?> binding) {
            this.operations.add(new InsertWrapperOperation(scope, binding));
            this.shouldMaterializeSyntaxNodes = true;
            return this;
        }

        BindingsVisitorBuilder addDisposeWrapperOperationForBinding(EventBinding.Source<?> binding) {
            this.operations.add(new DisposeWrapperOperation(VisitOperation.Scope.ALL, binding));
            return this;
        }

        BindingsVisitorBuilder addDisposeWrapperOperationForBindings(Collection<EventBinding.Source<?>> bindings) {
            this.operations.add(new DisposeWrapperOperation(VisitOperation.Scope.ALL, bindings));
            return this;
        }

        BindingsVisitor buildVisitor() {
            return new BindingsVisitor(this.shouldMaterializeSyntaxNodes, Collections.unmodifiableList(this.operations));
        }
    }

    private static class DisposeWrapperOperation
    extends VisitOperation {
        DisposeWrapperOperation(VisitOperation.Scope scope, EventBinding.Source<?> binding) {
            super(scope, binding);
        }

        DisposeWrapperOperation(VisitOperation.Scope scope, Collection<EventBinding.Source<?>> bindings) {
            super(scope, bindings, false);
        }

        @Override
        protected void perform(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private static class NotifyLoadedOperation
    extends VisitOperation {
        NotifyLoadedOperation(VisitOperation.Scope scope, EventBinding.Source<?> binding) {
            super(scope, binding);
        }

        NotifyLoadedOperation(VisitOperation.Scope scope, Collection<EventBinding.Source<?>> bindings) {
            super(scope, bindings, true);
        }

        @Override
        protected void perform(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.notifySourceSectionLoaded(binding, node, section);
        }
    }

    private class InsertWrapperOperation
    extends VisitOperation {
        InsertWrapperOperation(VisitOperation.Scope scope, EventBinding.Source<?> binding) {
            super(scope, binding);
        }

        InsertWrapperOperation(VisitOperation.Scope scope, Collection<EventBinding.Source<?>> bindings) {
            super(scope, bindings, false);
        }

        @Override
        protected void perform(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private static abstract class VisitOperation {
        private final Scope scope;
        private final Collection<EventBinding.Source<?>> bindings;
        private final boolean singleBindingOperation;
        private final boolean performForEachBinding;

        VisitOperation(Scope scope, EventBinding.Source<?> binding) {
            this(scope, Collections.singletonList(binding), true, true);
        }

        VisitOperation(Scope scope, Collection<EventBinding.Source<?>> bindings, boolean performForEachBinding) {
            this(scope, bindings, false, performForEachBinding);
        }

        VisitOperation(Scope scope, Collection<EventBinding.Source<?>> bindings, boolean singleBindingOperation, boolean performForEachBinding) {
            this.scope = scope;
            this.bindings = bindings;
            this.singleBindingOperation = singleBindingOperation;
            this.performForEachBinding = performForEachBinding;
        }

        protected abstract void perform(EventBinding.Source<?> var1, Node var2, SourceSection var3);

        static enum Scope {
            ALL,
            ONLY_ORIGINAL,
            ONLY_MATERIALIZED;

        }
    }

    private class ThreadLocalExecutedSourcesVisitor
    extends ThreadLocal<FindSourcesVisitor> {
        private ThreadLocalExecutedSourcesVisitor() {
        }

        @Override
        protected FindSourcesVisitor initialValue() {
            return new FindSourcesVisitor(InstrumentationHandler.this.sourcesExecuted, InstrumentationHandler.this.sourcesExecutedListRef);
        }
    }

    private class ThreadLocalSourcesVisitor
    extends ThreadLocal<FindSourcesVisitor> {
        private ThreadLocalSourcesVisitor() {
        }

        @Override
        protected FindSourcesVisitor initialValue() {
            return new FindSourcesVisitor(InstrumentationHandler.this.sources, InstrumentationHandler.this.sourcesListRef);
        }
    }

    private static class FindSourcesVisitor
    extends AbstractNodeVisitor {
        private final Map<Source, Void> sources;
        private final AtomicReference<SourceList> sourcesListRef;
        private final List<Source> rootSources = new ArrayList<Source>(5);

        FindSourcesVisitor(Map<Source, Void> sources, AtomicReference<SourceList> sourcesListRef) {
            super(true);
            this.sources = sources;
            this.sourcesListRef = sourcesListRef;
        }

        @Override
        boolean shouldVisit() {
            return true;
        }

        @Override
        protected void visitInstrumentable(Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            if (sourceSection != null) {
                this.adoptSource(sourceSection.getSource());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adoptSource(Source source) {
            Map<Source, Void> map = this.sources;
            synchronized (map) {
                if (!this.sources.containsKey(source)) {
                    this.sources.put(source, null);
                    this.sourcesListRef.get().add(source);
                    this.rootSources.add(source);
                }
            }
        }

        Source[] getSources() {
            if (this.rootSources.isEmpty()) {
                return null;
            }
            Source[] sourcesArray = this.rootSources.toArray(new Source[this.rootSources.size()]);
            this.rootSources.clear();
            return sourcesArray;
        }
    }
}

