/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputEndsWithNodeGen;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;

public abstract class InputEndsWithNode
extends Node {
    public static InputEndsWithNode create() {
        return InputEndsWithNodeGen.create();
    }

    public abstract boolean execute(Object var1, String var2, String var3);

    @Specialization(guards={"mask == null"})
    public boolean endsWith(String input, String suffix, String mask) {
        return input.endsWith(suffix);
    }

    @Specialization(guards={"mask != null"})
    public boolean endsWithWithMask(String input, String suffix, String mask) {
        return ArrayUtils.regionEqualsWithOrMask((String)input, (int)(input.length() - suffix.length()), (String)suffix, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean endsWithTruffleObjNoMask(TruffleObject input, String suffix, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean endsWithTruffleObjWithMask(TruffleObject input, String suffix, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        assert (mask.length() == suffix.length());
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, mask, lengthNode, charAtNode);
    }

    private static boolean endsWithTruffleObj(TruffleObject input, String suffix, String mask, InputLengthNode lengthNode, InputCharAtNode charAtNode) {
        int inputLength = lengthNode.execute(input);
        if (inputLength < suffix.length()) {
            return false;
        }
        int offset = inputLength - suffix.length();
        for (int i = 0; i < suffix.length(); ++i) {
            if (InputCharAtNode.charAtWithMask(input, offset + i, mask, i, charAtNode) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

