/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.result.LazyResult;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import java.util.Arrays;

public final class TraceFinderResult
extends LazyResult {
    private final int[] indices;
    private final CallTarget traceFinderCallTarget;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PreCalculatedResultFactory[] preCalculatedResults;
    private boolean resultCalculated = false;

    public TraceFinderResult(Object input, int fromIndex, int end, CallTarget traceFinderCallTarget, PreCalculatedResultFactory[] preCalculatedResults) {
        super(input, fromIndex, end);
        this.indices = new int[preCalculatedResults[0].getNumberOfGroups() * 2];
        this.traceFinderCallTarget = traceFinderCallTarget;
        this.preCalculatedResults = preCalculatedResults;
    }

    @Override
    public int getStart(int groupNumber) {
        return this.indices[groupNumber * 2];
    }

    @Override
    public int getEnd(int groupNumber) {
        return this.indices[groupNumber * 2 + 1];
    }

    public int[] getIndices() {
        return this.indices;
    }

    public CallTarget getTraceFinderCallTarget() {
        return this.traceFinderCallTarget;
    }

    public PreCalculatedResultFactory[] getPreCalculatedResults() {
        return this.preCalculatedResults;
    }

    public boolean isResultCalculated() {
        return this.resultCalculated;
    }

    public Object[] createArgsTraceFinder() {
        return new Object[]{this.getInput(), this.getEnd() - 1, this.getFromIndex()};
    }

    public void applyTraceFinderResult(int preCalcIndex) {
        this.preCalculatedResults[preCalcIndex].applyRelativeToEnd(this.indices, this.getEnd());
        this.resultCalculated = true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void debugForceEvaluation() {
        if (!this.isResultCalculated()) {
            this.applyTraceFinderResult((Integer)this.traceFinderCallTarget.call(this.createArgsTraceFinder()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (!this.isResultCalculated()) {
            this.debugForceEvaluation();
        }
        return Arrays.toString(this.indices);
    }
}

