/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PrivateFieldAddNode.class)
public final class PrivateFieldAddNodeGen
extends PrivateFieldAddNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedKeyData cachedKey_cache;

    private PrivateFieldAddNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public void execute(Object arg0Value, Object arg1Value, Object arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (arg1Value instanceof HiddenKey) {
                    CachedKeyData s1_;
                    HiddenKey arg1Value_ = (HiddenKey)arg1Value;
                    if ((state & 1) != 0 && (s1_ = this.cachedKey_cache) != null && arg1Value_ == s1_.cachedKey_ && JSGuards.isJSObject(arg0Value_)) {
                        this.doCachedKey(arg0Value_, arg1Value_, arg2Value, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                        return;
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(arg0Value_)) {
                        this.doUncachedKey(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            if ((state & 4) != 0 && PrivateFieldAddNodeGen.fallbackGuard_(arg0Value, arg1Value, arg2Value)) {
                this.doFallback(arg0Value, arg1Value, arg2Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (arg1Value instanceof HiddenKey) {
                    HiddenKey arg1Value_ = (HiddenKey)arg1Value;
                    if (exclude == 0) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 1) != 0 && arg1Value_ == s1_.cachedKey_ && JSGuards.isJSObject(arg0Value_)) {
                            CachedKey_duplicateFound_ = true;
                        }
                        if (!CachedKey_duplicateFound_ && JSGuards.isJSObject(arg0Value_) && (state & 1) == 0) {
                            s1_ = (CachedKeyData)super.insert((Node)new CachedKeyData());
                            s1_.cachedKey_ = arg1Value_;
                            s1_.hasNode_ = s1_.insertAccessor(HasHiddenKeyCacheNode.create(arg1Value_));
                            s1_.setNode_ = s1_.insertAccessor(PropertySetNode.createSetHidden(arg1Value_, this.context));
                            this.cachedKey_cache = s1_;
                            this.state_ = state |= 1;
                            CachedKey_duplicateFound_ = true;
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            this.doCachedKey(arg0Value_, arg1Value_, arg2Value, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            return;
                        }
                    }
                    if (JSGuards.isJSObject(arg0Value_)) {
                        this.exclude_ = exclude |= 1;
                        this.cachedKey_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        this.doUncachedKey(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            this.doFallback(arg0Value, arg1Value, arg2Value);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            CachedKeyData s1_ = this.cachedKey_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Object[]{s1_.cachedKey_, s1_.hasNode_, s1_.setNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(Object arg0Value, Object arg1Value, Object arg2Value) {
        DynamicObject arg0Value_;
        return !JSTypes.isDynamicObject(arg0Value) || !(arg1Value instanceof HiddenKey) || !JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value);
    }

    public static PrivateFieldAddNode create(JSContext context) {
        return new PrivateFieldAddNodeGen(context);
    }

    @GeneratedBy(value=PrivateFieldAddNode.class)
    private static final class CachedKeyData
    extends Node {
        @CompilerDirectives.CompilationFinal
        HiddenKey cachedKey_;
        @Node.Child
        HasHiddenKeyCacheNode hasNode_;
        @Node.Child
        PropertySetNode setNode_;

        CachedKeyData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

