/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.SortedClassLibraryBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.InvalidParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ComponentAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ExecuteAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.MojoAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ParameterAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScannerRequest;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=MojoDescriptorExtractor.class, hint="java-annotations")
public class JavaAnnotationsMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    @Requirement
    private MojoAnnotationsScanner mojoAnnotationsScanner;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArchiverManager archiverManager;

    public List<MojoDescriptor> execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Map<String, MojoAnnotatedClass> mojoAnnotatedClasses = this.scanAnnotations(request);
        Map<String, JavaClass> javaClassesMap = this.scanJavadoc(request, mojoAnnotatedClasses.values());
        this.populateDataFromJavadoc(mojoAnnotatedClasses, javaClassesMap);
        return this.toMojoDescriptors(mojoAnnotatedClasses, request.getPluginDescriptor());
    }

    private Map<String, MojoAnnotatedClass> scanAnnotations(PluginToolsRequest request) throws ExtractionException {
        MojoAnnotationsScannerRequest mojoAnnotationsScannerRequest = new MojoAnnotationsScannerRequest();
        File output = new File(request.getProject().getBuild().getOutputDirectory());
        mojoAnnotationsScannerRequest.setClassesDirectories(Arrays.asList(output));
        mojoAnnotationsScannerRequest.setDependencies(request.getDependencies());
        mojoAnnotationsScannerRequest.setProject(request.getProject());
        return this.mojoAnnotationsScanner.scan(mojoAnnotationsScannerRequest);
    }

    private Map<String, JavaClass> scanJavadoc(PluginToolsRequest request, Collection<MojoAnnotatedClass> mojoAnnotatedClasses) throws ExtractionException {
        ArrayList<MavenProject> mavenProjects = new ArrayList<MavenProject>();
        HashSet<Artifact> externalArtifacts = new HashSet<Artifact>();
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses) {
            if (StringUtils.equals((String)mojoAnnotatedClass.getArtifact().getArtifactId(), (String)request.getProject().getArtifact().getArtifactId()) || !this.isMojoAnnnotatedClassCandidate(mojoAnnotatedClass)) continue;
            MavenProject mavenProject = this.getFromProjectReferences(mojoAnnotatedClass.getArtifact(), request.getProject());
            if (mavenProject != null) {
                mavenProjects.add(mavenProject);
                continue;
            }
            externalArtifacts.add(mojoAnnotatedClass.getArtifact());
        }
        HashMap<String, JavaClass> javaClassesMap = new HashMap<String, JavaClass>();
        for (Artifact artifact : externalArtifacts) {
            if (StringUtils.equalsIgnoreCase((String)"tests", (String)artifact.getClassifier())) {
                javaClassesMap.putAll(this.discoverClassesFromSourcesJar(artifact, request, "test-sources"));
                continue;
            }
            javaClassesMap.putAll(this.discoverClassesFromSourcesJar(artifact, request, "sources"));
        }
        for (MavenProject mavenProject : mavenProjects) {
            javaClassesMap.putAll(this.discoverClasses(request.getEncoding(), mavenProject));
        }
        javaClassesMap.putAll(this.discoverClasses(request));
        return javaClassesMap;
    }

    private boolean isMojoAnnnotatedClassCandidate(MojoAnnotatedClass mojoAnnotatedClass) {
        return mojoAnnotatedClass != null && mojoAnnotatedClass.hasAnnotations();
    }

    protected Map<String, JavaClass> discoverClassesFromSourcesJar(Artifact artifact, PluginToolsRequest request, String classifier) throws ExtractionException {
        try {
            Artifact sourcesArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), classifier);
            this.artifactResolver.resolve(sourcesArtifact, request.getRemoteRepos(), request.getLocal());
            if (sourcesArtifact.getFile() == null || !sourcesArtifact.getFile().exists()) {
                return Collections.emptyMap();
            }
            File extractDirectory = new File(request.getProject().getBuild().getDirectory(), "maven-plugin-plugin-sources/" + sourcesArtifact.getGroupId() + "/" + sourcesArtifact.getArtifactId() + "/" + sourcesArtifact.getVersion() + "/" + sourcesArtifact.getClassifier());
            extractDirectory.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
            unArchiver.setSourceFile(sourcesArtifact.getFile());
            unArchiver.setDestDirectory(extractDirectory);
            unArchiver.extract();
            return this.discoverClasses(request.getEncoding(), Arrays.asList(extractDirectory), request.getDependencies());
        }
        catch (ArtifactResolutionException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("skip ArtifactNotFoundException:" + e.getMessage());
            this.getLogger().warn("Unable to get sources artifact for " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ". Some javadoc tags (@since, @deprecated and comments) won't be used");
            return Collections.emptyMap();
        }
        catch (NoSuchArchiverException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void populateDataFromJavadoc(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, Map<String, JavaClass> javaClassesMap) {
        for (Map.Entry<String, MojoAnnotatedClass> entry : mojoAnnotatedClasses.entrySet()) {
            JavaClass javaClass = javaClassesMap.get(entry.getKey());
            if (javaClass == null) continue;
            MojoAnnotationContent mojoAnnotationContent = entry.getValue().getMojo();
            if (mojoAnnotationContent != null) {
                DocletTag deprecated;
                mojoAnnotationContent.setDescription(javaClass.getComment());
                DocletTag since = this.findInClassHierarchy(javaClass, "since");
                if (since != null) {
                    mojoAnnotationContent.setSince(since.getValue());
                }
                if ((deprecated = this.findInClassHierarchy(javaClass, "deprecated")) != null) {
                    mojoAnnotationContent.setDeprecated(deprecated.getValue());
                }
            }
            Map<String, JavaField> fieldsMap = this.extractFieldParameterTags(javaClass, javaClassesMap);
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(entry.getValue(), new HashMap<String, ParameterAnnotationContent>(), mojoAnnotatedClasses);
            parameters = new TreeMap<String, ParameterAnnotationContent>(parameters);
            for (Map.Entry<String, ParameterAnnotationContent> parameter : parameters.entrySet()) {
                DocletTag since;
                JavaField javaField = fieldsMap.get(parameter.getKey());
                if (javaField == null) continue;
                ParameterAnnotationContent parameterAnnotationContent = parameter.getValue();
                parameterAnnotationContent.setDescription(javaField.getComment());
                DocletTag deprecated = javaField.getTagByName("deprecated");
                if (deprecated != null) {
                    parameterAnnotationContent.setDeprecated(deprecated.getValue());
                }
                if ((since = javaField.getTagByName("since")) == null) continue;
                parameterAnnotationContent.setSince(since.getValue());
            }
            Map<String, ComponentAnnotationContent> components = entry.getValue().getComponents();
            for (Map.Entry<String, ComponentAnnotationContent> component : components.entrySet()) {
                DocletTag since;
                JavaField javaField = fieldsMap.get(component.getKey());
                if (javaField == null) continue;
                ComponentAnnotationContent componentAnnotationContent = component.getValue();
                componentAnnotationContent.setDescription(javaField.getComment());
                DocletTag deprecated = javaField.getTagByName("deprecated");
                if (deprecated != null) {
                    componentAnnotationContent.setDeprecated(deprecated.getValue());
                }
                if ((since = javaField.getTagByName("since")) == null) continue;
                componentAnnotationContent.setSince(since.getValue());
            }
        }
    }

    private DocletTag findInClassHierarchy(JavaClass javaClass, String tagName) {
        JavaClass superClass;
        DocletTag tag = javaClass.getTagByName(tagName);
        if (tag == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            tag = this.findInClassHierarchy(superClass, tagName);
        }
        return tag;
    }

    private Map<String, JavaField> extractFieldParameterTags(JavaClass javaClass, Map<String, JavaClass> javaClassesMap) {
        Map<Object, Object> rawParams = new TreeMap();
        JavaClass superClass = javaClass.getSuperJavaClass();
        if (superClass != null) {
            if (superClass.getFields().size() > 0) {
                rawParams = this.extractFieldParameterTags(superClass, javaClassesMap);
            }
            if ((superClass = javaClassesMap.get(superClass.getFullyQualifiedName())) != null) {
                rawParams = this.extractFieldParameterTags(superClass, javaClassesMap);
            }
        } else {
            rawParams = new TreeMap();
        }
        for (JavaField field : javaClass.getFields()) {
            rawParams.put(field.getName(), field);
        }
        return rawParams;
    }

    protected Map<String, JavaClass> discoverClasses(PluginToolsRequest request) {
        return this.discoverClasses(request.getEncoding(), request.getProject());
    }

    protected Map<String, JavaClass> discoverClasses(String encoding, MavenProject project) {
        ArrayList<File> sources = new ArrayList<File>();
        for (String source : project.getCompileSourceRoots()) {
            sources.add(new File(source));
        }
        File generatedPlugin = new File(project.getBasedir(), "target/generated-sources/plugin");
        if (!project.getCompileSourceRoots().contains(generatedPlugin.getAbsolutePath()) && generatedPlugin.exists()) {
            sources.add(generatedPlugin);
        }
        return this.discoverClasses(encoding, sources, project.getArtifacts());
    }

    protected Map<String, JavaClass> discoverClasses(String encoding, List<File> sourceDirectories, Set<Artifact> artifacts) {
        JavaProjectBuilder builder = new JavaProjectBuilder((ClassLibraryBuilder)new SortedClassLibraryBuilder());
        builder.setEncoding(encoding);
        ArrayList<URL> urls = new ArrayList<URL>(artifacts.size());
        for (Artifact artifact : artifacts) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        builder.addClassLoader((ClassLoader)new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
        for (File source : sourceDirectories) {
            builder.addSourceTree(source);
        }
        Collection javaClasses = builder.getClasses();
        if (javaClasses == null || javaClasses.size() < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, JavaClass> javaClassMap = new HashMap<String, JavaClass>(javaClasses.size());
        for (JavaClass javaClass : javaClasses) {
            javaClassMap.put(javaClass.getFullyQualifiedName(), javaClass);
        }
        return javaClassMap;
    }

    private List<MojoDescriptor> toMojoDescriptors(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, PluginDescriptor pluginDescriptor) throws DuplicateParameterException, InvalidParameterException {
        ArrayList<MojoDescriptor> mojoDescriptors = new ArrayList<MojoDescriptor>(mojoAnnotatedClasses.size());
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses.values()) {
            if (mojoAnnotatedClass.getMojo() == null) continue;
            ExtendedMojoDescriptor mojoDescriptor = new ExtendedMojoDescriptor();
            mojoDescriptor.setImplementation(mojoAnnotatedClass.getClassName());
            mojoDescriptor.setLanguage("java");
            MojoAnnotationContent mojo = mojoAnnotatedClass.getMojo();
            mojoDescriptor.setDescription(mojo.getDescription());
            mojoDescriptor.setSince(mojo.getSince());
            mojo.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setProjectRequired(mojo.requiresProject());
            mojoDescriptor.setRequiresReports(mojo.requiresReports());
            mojoDescriptor.setComponentConfigurator(mojo.configurator());
            mojoDescriptor.setInheritedByDefault(mojo.inheritByDefault());
            mojoDescriptor.setInstantiationStrategy(mojo.instantiationStrategy().id());
            mojoDescriptor.setAggregator(mojo.aggregator());
            mojoDescriptor.setDependencyResolutionRequired(mojo.requiresDependencyResolution().id());
            mojoDescriptor.setDependencyCollectionRequired(mojo.requiresDependencyCollection().id());
            mojoDescriptor.setDirectInvocationOnly(mojo.requiresDirectInvocation());
            mojoDescriptor.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setThreadSafe(mojo.threadSafe());
            ExecuteAnnotationContent execute = this.findExecuteInParentHierarchy(mojoAnnotatedClass, mojoAnnotatedClasses);
            if (execute != null) {
                mojoDescriptor.setExecuteGoal(execute.goal());
                mojoDescriptor.setExecuteLifecycle(execute.lifecycle());
                if (execute.phase() != null) {
                    mojoDescriptor.setExecutePhase(execute.phase().id());
                }
            }
            mojoDescriptor.setExecutionStrategy(mojo.executionStrategy());
            mojoDescriptor.setGoal(mojo.name());
            mojoDescriptor.setOnlineRequired(mojo.requiresOnline());
            mojoDescriptor.setPhase(mojo.defaultPhase().id());
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(mojoAnnotatedClass, new HashMap<String, ParameterAnnotationContent>(), mojoAnnotatedClasses);
            for (ParameterAnnotationContent parameterAnnotationContent : new TreeSet<ParameterAnnotationContent>(parameters.values())) {
                Parameter parameter = new Parameter();
                String name = StringUtils.isEmpty((String)parameterAnnotationContent.name()) ? parameterAnnotationContent.getFieldName() : parameterAnnotationContent.name();
                parameter.setName(name);
                parameter.setAlias(parameterAnnotationContent.alias());
                parameter.setDefaultValue(parameterAnnotationContent.defaultValue());
                parameter.setDeprecated(parameterAnnotationContent.getDeprecated());
                parameter.setDescription(parameterAnnotationContent.getDescription());
                parameter.setEditable(!parameterAnnotationContent.readonly());
                String property = parameterAnnotationContent.property();
                if (StringUtils.contains((String)property, (char)'$') || StringUtils.contains((String)property, (char)'{') || StringUtils.contains((String)property, (char)'}')) {
                    throw new InvalidParameterException("Invalid property for parameter '" + parameter.getName() + "', forbidden characters ${}: " + property, null);
                }
                parameter.setExpression(StringUtils.isEmpty((String)property) ? "" : "${" + property + "}");
                parameter.setType(parameterAnnotationContent.getClassName());
                parameter.setSince(parameterAnnotationContent.getSince());
                parameter.setRequired(parameterAnnotationContent.required());
                mojoDescriptor.addParameter(parameter);
            }
            Map<String, ComponentAnnotationContent> components = this.getComponentsParentHierarchy(mojoAnnotatedClass, new HashMap<String, ComponentAnnotationContent>(), mojoAnnotatedClasses);
            for (ComponentAnnotationContent componentAnnotationContent : new TreeSet<ComponentAnnotationContent>(components.values())) {
                Parameter parameter = new Parameter();
                parameter.setName(componentAnnotationContent.getFieldName());
                String expression = (String)PluginUtils.MAVEN_COMPONENTS.get(componentAnnotationContent.getRoleClassName());
                if (expression == null) {
                    parameter.setRequirement(new org.apache.maven.plugin.descriptor.Requirement(componentAnnotationContent.getRoleClassName(), componentAnnotationContent.hint()));
                } else {
                    this.getLogger().warn("Deprecated @Component annotation for '" + parameter.getName() + "' field in " + mojoAnnotatedClass.getClassName() + ": replace with @Parameter( defaultValue = \"" + expression + "\", readonly = true )");
                    parameter.setDefaultValue(expression);
                    parameter.setType(componentAnnotationContent.getRoleClassName());
                    parameter.setRequired(true);
                }
                parameter.setDeprecated(componentAnnotationContent.getDeprecated());
                parameter.setSince(componentAnnotationContent.getSince());
                parameter.setEditable(false);
                mojoDescriptor.addParameter(parameter);
            }
            mojoDescriptor.setPluginDescriptor(pluginDescriptor);
            mojoDescriptors.add((MojoDescriptor)mojoDescriptor);
        }
        return mojoDescriptors;
    }

    protected ExecuteAnnotationContent findExecuteInParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        if (mojoAnnotatedClass.getExecute() != null) {
            return mojoAnnotatedClass.getExecute();
        }
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (StringUtils.isEmpty((String)parentClassName)) {
            return null;
        }
        MojoAnnotatedClass parent = mojoAnnotatedClasses.get(parentClassName);
        if (parent == null) {
            return null;
        }
        return this.findExecuteInParentHierarchy(parent, mojoAnnotatedClasses);
    }

    protected Map<String, ParameterAnnotationContent> getParametersParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, ParameterAnnotationContent> parameters, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ParameterAnnotationContent> parameterAnnotationContents = new ArrayList<ParameterAnnotationContent>();
        parameterAnnotationContents = this.getParametersParent(mojoAnnotatedClass, parameterAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(parameterAnnotationContents);
        HashMap<String, ParameterAnnotationContent> map = new HashMap<String, ParameterAnnotationContent>(parameterAnnotationContents.size());
        for (ParameterAnnotationContent parameterAnnotationContent : parameterAnnotationContents) {
            map.put(parameterAnnotationContent.getFieldName(), parameterAnnotationContent);
        }
        return map;
    }

    protected List<ParameterAnnotationContent> getParametersParent(MojoAnnotatedClass mojoAnnotatedClass, List<ParameterAnnotationContent> parameterAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        parameterAnnotationContents.addAll(mojoAnnotatedClass.getParameters().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getParametersParent(parent, parameterAnnotationContents, mojoAnnotatedClasses);
        }
        return parameterAnnotationContents;
    }

    protected Map<String, ComponentAnnotationContent> getComponentsParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, ComponentAnnotationContent> components, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ComponentAnnotationContent> componentAnnotationContents = new ArrayList<ComponentAnnotationContent>();
        componentAnnotationContents = this.getComponentParent(mojoAnnotatedClass, componentAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(componentAnnotationContents);
        HashMap<String, ComponentAnnotationContent> map = new HashMap<String, ComponentAnnotationContent>(componentAnnotationContents.size());
        for (ComponentAnnotationContent componentAnnotationContent : componentAnnotationContents) {
            map.put(componentAnnotationContent.getFieldName(), componentAnnotationContent);
        }
        return map;
    }

    protected List<ComponentAnnotationContent> getComponentParent(MojoAnnotatedClass mojoAnnotatedClass, List<ComponentAnnotationContent> componentAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        componentAnnotationContents.addAll(mojoAnnotatedClass.getComponents().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getComponentParent(parent, componentAnnotationContents, mojoAnnotatedClasses);
        }
        return componentAnnotationContents;
    }

    protected MavenProject getFromProjectReferences(Artifact artifact, MavenProject project) {
        if (project.getProjectReferences() == null || project.getProjectReferences().isEmpty()) {
            return null;
        }
        Collection mavenProjects = project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)artifact.getId())) continue;
            return mavenProject;
        }
        return null;
    }
}

