/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.text.MutableAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;

public class DoxiaUtils {
    private static final int MINUS_ONE = 255;
    private static final SimpleDateFormat DATE_PARSER = new SimpleDateFormat("", Locale.ENGLISH);
    private static final ParsePosition DATE_PARSE_POSITION = new ParsePosition(0);
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd", "yyyy", "dd.MM.yyyy", "dd MMM yyyy", "dd MMM. yyyy", "MMMM yyyy", "MMM. dd, yyyy", "MMM. yyyy", "MMMM dd, yyyy", "MMM d, ''yy", "MMM. ''yy", "MMMM ''yy"};

    public static boolean isInternalLink(String link) {
        return link.startsWith("#");
    }

    public static boolean isExternalLink(String link) {
        String text = link.toLowerCase(Locale.ENGLISH);
        return text.startsWith("http:/") || text.startsWith("https:/") || text.startsWith("ftp:/") || text.startsWith("mailto:") || text.startsWith("file:/") || text.contains("://");
    }

    public static boolean isLocalLink(String link) {
        return !DoxiaUtils.isExternalLink(link) && !DoxiaUtils.isInternalLink(link);
    }

    public static String encodeId(String id) {
        return DoxiaUtils.encodeId(id, false);
    }

    public static String encodeId(String id, boolean chop) {
        if (id == null) {
            return null;
        }
        String idd = id.trim();
        int length = idd.length();
        if (length == 0) {
            return "a";
        }
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            byte[] bytes;
            char c = idd.charAt(i);
            if (i == 0 && !DoxiaUtils.isAsciiLetter(c)) {
                buffer.append('a');
            }
            if (c == ' ') {
                buffer.append('_');
                continue;
            }
            if (DoxiaUtils.isAsciiLetter(c) || DoxiaUtils.isAsciiDigit(c) || c == '-' || c == '_' || c == ':' || c == '.') {
                buffer.append(c);
                continue;
            }
            if (chop) continue;
            try {
                bytes = String.valueOf(c).getBytes("UTF8");
            }
            catch (UnsupportedEncodingException cannotHappen) {
                bytes = new byte[]{};
            }
            for (int j = 0; j < bytes.length; ++j) {
                String hex = DoxiaUtils.byteToHex(bytes[j]);
                buffer.append('%');
                if (hex.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        return buffer.toString();
    }

    public static String byteToHex(byte b) {
        return Integer.toHexString(b & 0xFF);
    }

    public static boolean isValidId(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (DoxiaUtils.isAsciiLetter(c) || i != 0 && c != ' ' && (DoxiaUtils.isAsciiDigit(c) || c == '-' || c == '_' || c == ':' || c == '.')) continue;
            return false;
        }
        return true;
    }

    public static Date parseDate(String str) throws ParseException {
        if ("today".equalsIgnoreCase(str) || "now".equalsIgnoreCase(str)) {
            return new Date();
        }
        for (int i = 0; i < DATE_PATTERNS.length; ++i) {
            DATE_PARSER.applyPattern(DATE_PATTERNS[i]);
            DATE_PARSE_POSITION.setIndex(0);
            Date date = DATE_PARSER.parse(str, DATE_PARSE_POSITION);
            if (date == null || DATE_PARSE_POSITION.getIndex() != str.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse date: " + str, -1);
    }

    private static boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static MutableAttributeSet getImageAttributes(String logo) throws IOException {
        BufferedImage img = null;
        img = DoxiaUtils.isExternalLink(logo) ? ImageIO.read(new URL(logo)) : ImageIO.read(new File(logo));
        if (img == null) {
            return null;
        }
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("width", Integer.toString(img.getWidth()));
        atts.addAttribute("height", Integer.toString(img.getHeight()));
        return atts;
    }

    private DoxiaUtils() {
    }
}

