/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeMap
extends AbstractMap {
    private List maps;
    private boolean systemPropertiesFirst;

    public CompositeMap(List maps) {
        this(maps, false, false);
    }

    public CompositeMap(List maps, boolean useSystemProperties, boolean systemPropertiesFirst) {
        this.systemPropertiesFirst = systemPropertiesFirst;
        if (systemPropertiesFirst && !useSystemProperties) {
            throw new IllegalArgumentException("systemPropertiesFirst can't be true if useSystemProperties is false");
        }
        this.maps = new ArrayList();
        if (useSystemProperties && !systemPropertiesFirst) {
            if (maps != null) {
                this.maps.addAll(maps);
            }
            this.maps.add(System.getProperties());
        } else if (useSystemProperties && systemPropertiesFirst) {
            this.maps.add(System.getProperties());
            if (maps != null) {
                this.maps.addAll(maps);
            }
        } else if (maps != null) {
            this.maps.addAll(maps);
        }
    }

    public Object get(Object key) {
        if (this.maps != null) {
            Iterator iterator = this.maps.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                Object value = map.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("Cannot enumerate properties in a composite map");
    }

    public List getMaps() {
        return this.maps;
    }

    public void addMap(Map map) {
        this.maps.add(map);
    }

    public boolean isSystemPropertiesFirst() {
        return this.systemPropertiesFirst;
    }

    public void setSystemPropertiesFirst(boolean systemPropertiesFirst) {
        this.systemPropertiesFirst = systemPropertiesFirst;
    }
}

