/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class BaseTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.html.LocalStrings");
    protected final String REF_SITE = "site";
    protected final String REF_PAGE = "page";
    protected String server = null;
    protected String target = null;
    protected String ref = "page";

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Ref attribute cannot be null");
        }
        if (!(ref = ref.toLowerCase()).equals("page") && !ref.equals("site")) {
            throw new IllegalArgumentException("Ref attribute must either be 'page' or 'site'");
        }
        this.ref = ref;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String serverName = this.server == null ? request.getServerName() : this.server;
        int port = request.getServerPort();
        String headerHost = request.getHeader("Host");
        if (serverName == null && headerHost != null) {
            StringTokenizer tokenizer = new StringTokenizer(headerHost, ":");
            serverName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String portS = tokenizer.nextToken();
                try {
                    port = Integer.parseInt(portS);
                }
                catch (Exception e) {
                    port = 80;
                }
            } else {
                port = 80;
            }
        }
        String baseTag = this.renderBaseElement(request.getScheme(), serverName, port, request.getRequestURI());
        JspWriter out = this.pageContext.getOut();
        try {
            out.write(baseTag);
        }
        catch (IOException e) {
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 1;
    }

    protected String renderBaseElement(String scheme, String serverName, int port, String uri) {
        StringBuffer tag = new StringBuffer("<base href=\"");
        if (this.ref.equals("site")) {
            StringBuffer contextBase = new StringBuffer(((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
            contextBase.append("/");
            tag.append(RequestUtils.createServerUriStringBuffer((String)scheme, (String)serverName, (int)port, (String)contextBase.toString()).toString());
        } else {
            tag.append(RequestUtils.createServerUriStringBuffer((String)scheme, (String)serverName, (int)port, (String)uri).toString());
        }
        tag.append("\"");
        if (this.target != null) {
            tag.append(" target=\"");
            tag.append(this.target);
            tag.append("\"");
        }
        if (TagUtils.getInstance().isXhtml(this.pageContext)) {
            tag.append(" />");
        } else {
            tag.append(">");
        }
        return tag.toString();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

