/**************************************************
 *
 *
 **************************************************
 * This code was created by Peter Harvey @ CodeByDesign.
 * Released under LGPL 31.JAN.99
 *
 * Contributions from...
 * -----------------------------------------------
 * Peter Harvey		- pharvey@codebydesign.com
 **************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <odbcinstext.h>
#include <string.h>

/**********************************************
 * HELP
 **********************************************/

static const char *szHelpPassword = "Your Password will be used to gain additional information from the DBMS and will not be saved anywhere.";

/**********************************************
 * STATIC LOOKUP VALUES
 **********************************************/
static const char *aServer[] =
{
	"localhost",
	NULL
};

static const char *aPort[] =
{
	"5432",
	NULL
};


static const char *aYesNo[] =
{
	"Yes",
	"No",
	NULL
};

static const char *aSSLOpt[] = 
{
	"IGNORE",
	"ALLOW",
	"PREFER",
	"REQUIRE",
	NULL
};

static const char *aClientEnc[] = 
{
	"SQL_ASCII", "EUC_CN", "EUC_KR", "EUC_TW",
	"EUC_JP",    "JOHAB",  "LATIN1", "LATIN2",
	"LATIN3",    "LATIN4", "LATIN5", "LATIN6",
	"LATIN7",    "LATIN8", "LATIN9", "LATIN10",
	"ISO_8859_5","ISO_8859_6", "ISO_8859_7", "ISO_8859_8",
	"WIN",       "WIN1250","WIN1256","WIN874",
	"SJIS",      "UHC",    "GBK",    "TCVN",
	"GB18030",   "ALT",    "KOI8",   "MULE_INTERNAL",
	"TCVN",      "UNICODE",
	NULL
};

int ODBCINSTGetProperties( HODBCINSTPROPERTY hLastProperty )
{ 
	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_TEXTEDIT;
	strncpy( hLastProperty->szName, "DATABASE", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_COMBOBOX;
	hLastProperty->aPromptData			= (char**)malloc( sizeof( aServer ) );
	memcpy( hLastProperty->aPromptData, aServer, sizeof( aServer ) );
	strncpy( hLastProperty->szName, "SERVER", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "localhost", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_TEXTEDIT;
	strncpy( hLastProperty->szName, "UID", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_TEXTEDIT_PASSWORD;
    hLastProperty->pszHelp				= (char *)strdup( szHelpPassword );
	strncpy( hLastProperty->szName, "PWD", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_COMBOBOX;
    hLastProperty->aPromptData			= (char**)malloc( sizeof(aPort) );
	memcpy( hLastProperty->aPromptData, aPort, sizeof(aPort) );
	strncpy( hLastProperty->szName, "PORT", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "5432", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_TEXTEDIT;
	strncpy( hLastProperty->szName, "CONNECT_TIMEOUT", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
	
	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_LISTBOX;
        hLastProperty->aPromptData			= (char**)malloc( sizeof(aSSLOpt) );
	memcpy( hLastProperty->aPromptData, aSSLOpt, sizeof(aSSLOpt) );
	strncpy( hLastProperty->szName, "USE_SSL", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "IGNORE", INI_MAX_PROPERTY_VALUE );

        hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 					= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_LISTBOX;
        hLastProperty->aPromptData			= (char**)malloc( sizeof(aClientEnc) );
	memcpy( hLastProperty->aPromptData, aClientEnc, sizeof(aClientEnc) );
	strncpy( hLastProperty->szName, "CLIENT_ENCODING", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "UNICODE", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_LISTBOX;
    hLastProperty->aPromptData			= (char**)malloc( sizeof(aYesNo) );
	memcpy( hLastProperty->aPromptData, aYesNo, sizeof(aYesNo) );
	strncpy( hLastProperty->szName, "USE_BUFFERING", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "Yes", INI_MAX_PROPERTY_VALUE );

	hLastProperty->pNext                            = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
        hLastProperty                                           = hLastProperty->pNext;
        memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
        hLastProperty->nPromptType                      = ODBCINST_PROMPTTYPE_TEXTEDIT;
    hLastProperty->pszHelp                              = NULL; 
        strncpy( hLastProperty->szName, "SSL_CERTIFICATE",  INI_MAX_PROPERTY_NAME );
        strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

       hLastProperty->pNext                            = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
        hLastProperty                                           = hLastProperty->pNext;
        memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
        hLastProperty->nPromptType                      = ODBCINST_PROMPTTYPE_TEXTEDIT;
    hLastProperty->pszHelp                              = NULL;
        strncpy( hLastProperty->szName, "SSL_PRIVATE_KEY",  INI_MAX_PROPERTY_NAME );
        strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

       hLastProperty->pNext                            = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
        hLastProperty                                           = hLastProperty->pNext;
        memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
        hLastProperty->nPromptType                      = ODBCINST_PROMPTTYPE_TEXTEDIT_PASSWORD;
    hLastProperty->pszHelp                              = NULL;
        strncpy( hLastProperty->szName, "SSL_PASSPHRASE",  INI_MAX_PROPERTY_NAME );
        strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );


	hLastProperty->pNext 				= (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
	hLastProperty 						= hLastProperty->pNext;
	memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
	hLastProperty->nPromptType			= ODBCINST_PROMPTTYPE_TEXTEDIT;
    hLastProperty->pszHelp                              = NULL;
	strncpy( hLastProperty->szName, "ALLOWED_OBJECTS", INI_MAX_PROPERTY_NAME );
	strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );

	return 1;
}

