#!/bin/bash

DBUSER=postgres

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

PWD=`pwd`
chmod +x *.sh

echo 'input database name in roman'
read DBNAME
echo

echo '----- create schema -----'
#echo 'drop schema...'
#su - ${DBUSER} -c "psql -f ${PWD}/dropschema.sql ${DBNAME}"
#echo
#sleep 3
#echo
echo 'create schema...'
su - ${DBUSER} -c "psql -f ${PWD}/createschema.sql ${DBNAME}";
echo

sleep 2

echo '----- create function -----'
echo
echo 'create or replace function...'
su - ${DBUSER} -c "psql -f ${PWD}/createfunction.sql ${DBNAME}";
echo 
echo 'create gc function...'
su - ${DBUSER} -c "psql -f ${PWD}/gc_pathexp.sql ${DBNAME}";
echo
echo 'create DOM function...'
su - ${DBUSER} -c "psql -f ${PWD}/dom_l2.sql ${DBNAME}";
echo


sleep 2

echo '----- create or renew index -----'
echo
echo 'phase 1...'
su - ${DBUSER} -c "psql -f ${PWD}/createidx-1.sql ${DBNAME}";
echo
echo 'phase 2...' 
su - ${DBUSER} -c "psql -f ${PWD}/createidx-2.sql ${DBNAME}";
echo 
echo 'phase 3...'
su - ${DBUSER} -c "psql -f ${PWD}/createidx-3.sql ${DBNAME}";
echo

sleep 2

echo '----- create index for dewey -----'
su - ${DBUSER} -c "psql -f ${PWD}/createidx-dewey.sql ${DBNAME}"
echo
echo 'Please drop this index, if an updating performance is more important '
echo 'than a selection one.' 

sleep 1

echo
echo '------ create index for xpath queries -----'
./afterload.sh ${DBNAME}
echo

sleep 2

echo
echo '----- initial data input -----'
su - ${DBUSER} -c "psql -f ${PWD}/initdata.sql ${DBNAME}"
echo

sleep 2

echo
echo '----- create trigger -----'
su - ${DBUSER} -c "psql -f ${PWD}/xorder.sql ${DBNAME}";
echo

sleep 1

echo
echo 'finish!'
