/*
 * stack.h -- stack routines
 *
 * Part of publib
 * stack.h,v 1.1 2003/07/17 14:10:45 myui Exp
 */

#ifndef __publib_stack_h
#define __publib_stack_h

#include <stddef.h>    /* need size_t */

struct __stack {
    void **data;
    size_t *size;
    size_t count;
    size_t allocated, used;
};
typedef struct __stack Stack;

Stack *stack_create(void);
void stack_destroy(Stack *);
void stack_init(Stack *);
void *stack_pop(Stack *);
void *stack_peek(Stack *);
int stack_is_empty(Stack *);
int stack_push(Stack *, void *__data, size_t __bytes);
int stack_push_pointer(Stack *, void *__data);

#endif
