DROP TRIGGER trg_xorder ON xml_node;

-- CAUTION!!
-- if changed pathexp that have pathid equal to nodeid, then path modification cascades

CREATE OR REPLACE FUNCTION trg_xorder() RETURNS TRIGGER AS '
DECLARE
    v_pathexp VARCHAR;
    v_dewey   INTEGER[];
    v_dims    INTEGER;
    v_localorder INTEGER;
    v_nxtpathid INTEGER;
BEGIN
    RAISE NOTICE ''[trg_xorder] enter\n nodeid=%'',NEW.id;
    -- unlinked
    IF NEW.parent IS NULL THEN
        RAISE NOTICE ''no need changing'';
        RETURN NULL;
    END IF;
    -- there are no changing
    IF NEW.parent = OLD.parent AND (NEW.tagid = OLD.tagid OR NEW.tagid IS NULL) THEN
        -- if change the position of brothers
        RAISE NOTICE ''no need changing'';
        RETURN NULL;
    END IF;
    -- already chanded
    IF NEW.dewey != OLD.dewey OR NEW.pathid != OLD.pathid THEN
        RAISE NOTICE ''no need changing'';
        RETURN NULL;
    END IF;

    -- calculate local order
    IF NEW.kind > 0 AND NEW.kind < 5 THEN
        SELECT INTO v_localorder
            last(dewey)+1
        FROM
        	xml_node
        WHERE next=NEW.id;
   		IF NOT FOUND THEN
   			v_localorder := 1;
   		END IF;
    END IF;

    -- element
    IF NEW.kind = 1 THEN
        SELECT INTO v_pathexp,v_dewey,v_dims
            xp.pathexp || ''#/'' || (SELECT
                                        name
                                    FROM
                                        xml_tag
                                    WHERE
                                        tagid=NEW.tagid
                                    ),
            pn.dewey + v_localorder,
            icount(pn.dewey) + 1
        FROM
            xml_node pn,
            xml_path xp
        WHERE
            pn.id = NEW.parent AND
            xp.pathid = pn.pathid;
        IF NOT FOUND THEN
            RAISE NOTICE ''result not found'';
        END IF;
        -- set regular path expression
        IF NEW.dewey IS NULL THEN
            INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.id,v_pathexp);
        ELSE
            -- update influence node label
            IF NEW.next IS NOT NULL THEN
                UPDATE
                    xml_node
                SET
                    dewey[v_dims] = dewey[v_dims] + 1
                WHERE
                    subarray(dewey,1,v_dims-1) = subarray(v_dewey,1,v_dims-1) AND
                    dewey[v_dims] >= v_localorder;
            END IF;
            -- set insert-node descendant path and label
            IF NEW.child IS NOT NULL THEN
 
                -- set dewey info
                UPDATE
                    xml_node
                SET
                    dewey=(v_dewey + subarray(dewey,icount(NEW.dewey)+1)) AND
                    dewey[2] = _int_vdim(v_dewey,2)
                WHERE
                    _int_descendant(dewey,NEW.dewey);
 
                -- set pathexp
                IF NEW.id != NEW.pathid THEN
					INSERT INTO xml_path(pathid,pathexp)
						SELECT
							NEW.id, pathexp
						FROM
							xml_path
						WHERE
							pathid = NEW.pathid
						Order by
							pathid asc
						Limit 1;
                ELSIF IsUnited(NEW.pathid) IS TRUE THEN
					SELECT INTO v_nxtpathid
						id
					FROM
						xml_node
					WHERE
						pathid = NEW.pathid
					ORDER BY pathid LIMIT 1 OFFSET 2;
					INSERT INTO xml_path(pathid,pathexp)
					    VALUES(
					    	v_nxtpathid,
					    	(SELECT pathexp FROM xml_path WHERE pathid = NEW.pathid)
					    );
					UPDATE xml_node SET pathid = v_nxtpathid WHERE pathid = NEW.pathid;
                END IF;
                UPDATE
                    xml_path
                SET
                    pathexp=h_replace(pathexp,
                                     (SELECT
                                        pathexp
                                      FROM
                                        xml_path
                                      WHERE
                                        pathid=NEW.pathid
                                      ),
                                     v_pathexp
                                    )
                FROM
                    xml_node cn
                WHERE
                    _int_descendant(cn.dewey,v_dewey) AND
                    xml_path.pathid = cn.pathid; --AND xml_path.united IS NULL;
            END IF;
        END IF;
        -- set regular path expression
        -- set dewey order infomation
        IF NEW.pathid = NEW.id THEN
            UPDATE xml_path SET pathexp=v_pathexp WHERE pathid=NEW.id;
            UPDATE xml_node SET dewey=v_dewey WHERE id=NEW.id;
        ELSE
            INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.id,v_pathexp);
            UPDATE xml_node SET pathid=NEW.id AND dewey=v_dewey WHERE id=NEW.id;
        END IF;
        -- set dewey order infomation
    -- text comment pi
    ELSIF NEW.kind = 2 OR NEW.kind = 3 OR NEW.kind = 4 THEN
        SELECT INTO v_pathexp,v_dewey,v_dims
            xp.pathexp || ''#/'',
            pn.dewey + v_localorder,
            icount(pn.dewey) + 1
        FROM
            xml_node pn,
            xml_path xp
        WHERE
            pn.id = NEW.parent AND
            xp.pathid = pn.pathid;
        IF NOT FOUND THEN
            RAISE NOTICE ''result not found'';
        END IF;
        -- set pathexp
        IF NEW.dewey IS NULL THEN
            INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.pathid,v_pathexp);
        ELSE
            IF NEW.pathid = NEW.id THEN
                UPDATE xml_path SET pathexp=v_pathexp WHERE pathid=NEW.id;
            ELSE
                INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.id,v_pathexp);
                UPDATE xml_node SET pathid=NEW.id WHERE id=NEW.id;
            END IF;
            --
			-- update influenced node's label
        END IF;
        -- set ddo
        UPDATE xml_node SET dewey=v_dewey WHERE id=NEW.id;
    -- attribute
    ELSIF NEW.kind = 5 THEN
        SELECT INTO v_pathexp,v_dewey
            xp.pathexp || ''#/@'' || (SELECT
                                        name
                                    FROM
                                        xml_attribute
                                    WHERE
                                        tagid=NEW.tagid
                                    ),
            pn.dewey + 0
        FROM
            xml_node pn,
            xml_path xp
        WHERE
            pn.id=NEW.parent AND
            xp.pathid=pn.pathid;
        IF NOT FOUND THEN
            RAISE NOTICE ''result not found'';
        END IF;
        -- set pathexp
        IF NEW.dewey IS NULL THEN
            INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.pathid,v_pathexp);
        ELSE
            IF NEW.pathid = NEW.id THEN
                UPDATE xml_path SET path_exp=v_pathexp WHERE pathid=NEW.id;
            ELSE
                INSERT INTO xml_path(pathid,pathexp) VALUES(NEW.id,v_pathexp);
                UPDATE xml_node SET pathid=NEW.id WHERE id=NEW.id;
            END IF;
        END IF;
        -- set ddo
        UPDATE xml_node SET dewey=v_dewey WHERE id=NEW.id;
    -- namespace
    ELSIF NEW.kind = 6 THEN
        UPDATE
            xml_node
        SET
            dewey=(SELECT dewey + 0 FROM xml_node WHERE id=NEW.parent)
        WHERE
            id=NEW.id;
    ELSE
        RETURN NULL;
    END IF;
    RAISE NOTICE ''[trg_xorder] finish'';
    RETURN NULL;
END;
' LANGUAGE 'plpgsql';

CREATE TRIGGER trg_xorder AFTER UPDATE ON xml_node FOR EACH ROW
EXECUTE PROCEDURE trg_xorder();