BEGIN;

CREATE TABLE "xml_document" (
	"docid" INTEGER PRIMARY KEY,
	"name" VARCHAR,
	"header" VARCHAR,
	"dtd" VARCHAR,
	"valid" BOOLEAN
);
GRANT ALL ON "xml_document" TO PUBLIC;

CREATE SEQUENCE xml_nodeid_seq MAXVALUE 2147483647 CACHE 2 START 1;
CREATE SEQUENCE xml_node_dummy_seq MAXVALUE 2147483647 START 1 CACHE 2 CYCLE;
CREATE TABLE "xml_node" (
	"id" INTEGER PRIMARY KEY,
	"kind" SMALLINT,
	"docid" INTEGER,
	"pathid" INTEGER,
	"dewey" INTEGER[],
	"parent" INTEGER,
	"child" INTEGER,
	"next" INTEGER,		-- child link will be combined to next
	"tagid" INTEGER,
	"value" VARCHAR		-- value will be replaced to foreigh table with nodeid as key
);
GRANT ALL ON "xml_node" TO PUBLIC;

/*
create table "xml_nodeval" (
	"id" INTEGER PRIMARY KEY,
	"value" VARCHAR
);
*/

CREATE TABLE "xml_path" (
    "pathid" INTEGER PRIMARY KEY,
    "pathexp" VARCHAR,
   	"united" BOOLEAN		-- NULL(can gc),true(collected),false(tmp)
);
GRANT ALL ON "xml_path" TO PUBLIC;

CREATE SEQUENCE xml_tagid_seq CACHE 2 MAXVALUE 2147483647;
CREATE TABLE "xml_tag" (
	"tagid" INTEGER PRIMARY KEY,
	"name" VARCHAR
);
GRANT ALL ON "xml_tag" TO PUBLIC;

CREATE SEQUENCE xml_attid_seq MAXVALUE 2147483647;
CREATE TABLE "xml_attribute" (
	"tagid" INTEGER PRIMARY KEY,
	"name" VARCHAR
);
GRANT ALL ON "xml_attribute" TO PUBLIC;

CREATE SEQUENCE xml_nsid_seq MAXVALUE 2147483647;
CREATE TABLE "xml_namespace" (
	"tagid" INTEGER PRIMARY KEY,
	"name" VARCHAR
);
GRANT ALL ON "xml_namespace" TO PUBLIC;

CREATE SEQUENCE xml_piid_seq MAXVALUE 2147483647;
CREATE TABLE "xml_pi" (
	"tagid" INTEGER PRIMARY KEY,
	"name" VARCHAR
);
GRANT ALL ON "xml_pi" TO PUBLIC;

CREATE TABLE "domimpl" (
	"feature" VARCHAR PRIMARY KEY,
	"version" VARCHAR NOT NULL
);
GRANT ALL ON "domimpl" TO PUBLIC;

END;
