#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <net/ethernet.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <sys/time.h>

#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>

using namespace std;


#include "ip.h"
#include "prio.h"

EXEC SQL INCLUDE sqlca;

void	SQLConnect(char *connectionInfo)
{
	EXEC SQL BEGIN DECLARE SECTION;
	char	*connection;
	EXEC SQL END DECLARE SECTION;

	connection = connectionInfo;

	EXEC SQL CONNECT TO :connection;
	if(sqlca.sqlcode) {
		fprintf(stderr, "error connecting to database\n");
		exit(0);
	}
#if 1
	else 
		cout << "connection to " << connectionInfo << " OK" << endl;
#endif
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}

static int	records;

void	SQlSaveRecord(CRecord *cr)
{
	EXEC SQL BEGIN DECLARE SECTION;
	char  f_ip_src[16];
	char	f_ip_dst[16];
	int	f_port_src;
	int 	f_port_dst;
	int	f_ip_proto;
	int 	f_volume;
	int	f_packets;
	char	f_lastUpdate[30];
	char  f_firstUpdate[30];
	EXEC SQL END DECLARE SECTION;

	strcpy(f_ip_src, inet_ntoa(cr->ip_src_m));
	strcpy(f_ip_dst, inet_ntoa(cr->ip_dst_m));
	f_port_src = cr->port_src_m;
	f_port_dst = cr->port_dst_m;
	f_ip_proto = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	timevalToDate(&cr->lastUpdate_m, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_m, f_firstUpdate);

	EXEC SQL INSERT INTO usage (ip_src, ip_dst, port_src, port_dst, 
		number, 
		first_seen, last_seen, packets,
		volume)
			VALUES (:f_ip_src, :f_ip_dst, :f_port_src, :f_port_dst,
				:f_ip_proto, 
				:f_firstUpdate, :f_lastUpdate,
				:f_packets,
				:f_volume);
	if (sqlca.sqlcode != 0) {//  && sqlca.sqlerrm.sqlerrml != 69) {
		printf("Error #%d: %s\n", sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		exit(1);
	}
	records++;
}


void	SQLCommit()
{
	EXEC SQL COMMIT;
	cerr << "commit " << records << endl;
	records = 0;
}
