

struct CRecord : public PrioRecord {
    struct in_addr  ip_src_m;
	int	srcSerial_m;
    struct in_addr  ip_dst_m;
	int dstSerial_m;
    u_int16_t port_src_m;
    u_int16_t port_dst_m;
    u_int8_t ip_proto_m;
    int volume_m;
	int packets_m;
	char *llSrc_m;
	char *llDst_m;
	string	data_;
	string	key_;

	CRecord(CRecord *cr);
    CRecord(const struct ip *ip, int port_src, int port_dst, int volume, const char *llSrc, const char *llDst, string data);
    ~CRecord();
	// overrides for priority Q class
	string  MakeKey() { return key_; }

    friend ostream& operator<<(ostream &os, const CRecord *cr);

	void	update(PrioRecord *pr) {
		CRecord	*cr = static_cast<CRecord *>(pr);
		volume_m += cr->volume_m;
		packets_m++; 
		data_ += cr->data_;
	}
	CRecord *create() {
		return new CRecord(this);
	}
	void	Print(ostream &os);
};


class RTable : public PrioList {
	int		SleepTime_m;
	int	dataLinkType_m;
	DnsCache	*dnsCache_m;
	int	age_;
	string	interfaceName_m;
	pcap_t *descr_m;
public:
	RTable(int SleepTime, DnsCache *dnsCache_m, int age, int fullFlushOnMinDiv, char *device);

//	void	Accumulate(CRecord *cr, struct timeval when, int dataLen, unsigned char *data);

	int	Get_DataLinkType() const { return dataLinkType_m; }
	int	Get_Age() const { return age_; }
	int FindHostFromIP(const struct in_addr& ip, const char *mac) const  { 
		return dnsCache_m->FindHostFromIP(ip, mac);
	}
	string Get_InterfaceName()  const { return interfaceName_m; }
	DnsCache	*Get_DnsCache() const { return dnsCache_m; }
	int	Get_SleepTime() const { return SleepTime_m; }
	pcap_t	*Get_descr() const { return descr_m; }
	void	Set_tcapInfo(pcap_t *descr);

	friend ostream& operator<<(ostream &os, RTable& rtt);
	// TODO: add accessors
	int	Get_fullFLushInterval() const { return fullFlushInterval_; }
	int	fullFlushInterval_;
	time_t	nextFlush_;
};


extern ostream& operator<<(ostream &os, struct timeval tv);
