
/* Module:          options.c
 *
 * Description:     This module contains routines for getting/setting
 *                  connection and statement options.
 *
 * Classes:         n/a
 *
 * API functions:   None
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h" 


RETCODE set_statement_option(ConnectionClass *conn, 
							 StatementClass *stmt, 
							 UWORD   fOption,
							 UDWORD  vParam);



RETCODE set_statement_option(ConnectionClass *conn, 
							 StatementClass *stmt, 
							 UWORD   fOption,
							 UDWORD  vParam)
{
	static char *func="set_statement_option";
	char changed = FALSE;


	switch(fOption) 
	{
	case SQL_ASYNC_ENABLE:/* ignored */
		break;

	case SQL_BIND_TYPE:		
		/* now support multi-column and multi-row binding */
		if (conn) conn->stmtOptions.bind_size = vParam;
		if (stmt) stmt->options.bind_size = vParam;
		break;

	case SQL_CONCURRENCY:
		/*	positioned update isn't supported so cursor concurrency is read-only */

		if (conn) conn->stmtOptions.scroll_concurrency = vParam;
		if (stmt) stmt->options.scroll_concurrency = vParam;
		break;

		/*
		if (globals.lie) {
			if (conn) conn->stmtOptions.scroll_concurrency = vParam;
			if (stmt) stmt->options.scroll_concurrency = vParam;
		}
		else {

			if (conn) conn->stmtOptions.scroll_concurrency = SQL_CONCUR_READ_ONLY;
			if (stmt) stmt->options.scroll_concurrency = SQL_CONCUR_READ_ONLY;

			if (vParam != SQL_CONCUR_READ_ONLY)
				changed = TRUE;
		}
		break;
		*/
		
	case SQL_CURSOR_TYPE:
		/*	if declare/fetch, then type can only be forward.
			otherwise, it can only be forward or static.
		*/
		mylog("SetStmtOption(): SQL_CURSOR_TYPE = %d\n", vParam);

		if (globals.lie) 
		{

			if (conn) conn->stmtOptions.cursor_type = vParam;
			if (stmt) stmt->options.cursor_type = vParam;

		}
		else 
		{
			if (globals.use_declarefetch) 
			{

				if (conn) conn->stmtOptions.cursor_type = SQL_CURSOR_FORWARD_ONLY;
				if (stmt) stmt->options.cursor_type = SQL_CURSOR_FORWARD_ONLY;

				if (vParam != SQL_CURSOR_FORWARD_ONLY) 
					changed = TRUE;
			}
			else 
			{
				if (vParam == SQL_CURSOR_FORWARD_ONLY || vParam == SQL_CURSOR_STATIC)
				{

					if (conn) conn->stmtOptions.cursor_type = vParam;		/* valid type */
					if (stmt) stmt->options.cursor_type = vParam;		/* valid type */
				}
				else 
				{

					if (conn) conn->stmtOptions.cursor_type = SQL_CURSOR_STATIC;
					if (stmt) stmt->options.cursor_type = SQL_CURSOR_STATIC;

					changed = TRUE;
				}
			}
		}
		break;

	case SQL_KEYSET_SIZE: /* ignored, but saved and returned  */
		mylog("SetStmtOption(): SQL_KEYSET_SIZE, vParam = %d\n", vParam);

		if (conn) conn->stmtOptions.keyset_size = vParam;
		if (stmt) stmt->options.keyset_size = vParam;

		break;

		/*
		if (globals.lie)
			stmt->keyset_size = vParam;
		else {
			stmt->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
			stmt->errormsg = "Driver does not support keyset size option";
			SC_log_error(func, "", stmt);
			return SQL_ERROR;
		}
		*/

	case SQL_MAX_LENGTH:/* ignored, but saved */
		mylog("SetStmtOption(): SQL_MAX_LENGTH, vParam = %d\n", vParam);
		if (conn) conn->stmtOptions.maxLength = vParam;
		if (stmt) stmt->options.maxLength = vParam;
		break;

	case SQL_MAX_ROWS: /* ignored, but saved */
		mylog("SetStmtOption(): SQL_MAX_ROWS, vParam = %d\n", vParam);
		if (conn) conn->stmtOptions.maxRows = vParam;
		if (stmt) stmt->options.maxRows = vParam;
		break;

	case SQL_NOSCAN: /* ignored */
		mylog("SetStmtOption: SQL_NOSCAN, vParam = %d\n", vParam);
		break;

	case SQL_QUERY_TIMEOUT: /* ignored */
		mylog("SetStmtOption: SQL_QUERY_TIMEOUT, vParam = %d\n", vParam);
		/*	"0" returned in SQLGetStmtOption */
		break;

	case SQL_RETRIEVE_DATA: /* ignored, but saved */
		mylog("SetStmtOption(): SQL_RETRIEVE_DATA, vParam = %d\n", vParam);
		if (conn) conn->stmtOptions.retrieve_data = vParam;
		if (stmt) stmt->options.retrieve_data = vParam;
		break;

	case SQL_ROWSET_SIZE:
		mylog("SetStmtOption(): SQL_ROWSET_SIZE, vParam = %d\n", vParam);


		/*	Save old rowset size for SQLExtendedFetch purposes 
			If the rowset_size is being changed since the last call
			to fetch rows.
		*/

		if (stmt && stmt->save_rowset_size <= 0 && stmt->last_fetch_count > 0 )
			stmt->save_rowset_size = stmt->options.rowset_size;

		if (vParam < 1)
		{
			vParam = 1;
			changed = TRUE;
		}

		if (conn) conn->stmtOptions.rowset_size = vParam;
		if (stmt) stmt->options.rowset_size = vParam;

		break;

	case SQL_SIMULATE_CURSOR: /* NOT SUPPORTED */
		if (stmt) 
		{
			stmt->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
			stmt->errormsg = "Simulated positioned update/delete not supported.  Use the cursor library.";
			SC_log_error(func, "", stmt);
		}
		if (conn) 
		{
			conn->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
			conn->errormsg = "Simulated positioned update/delete not supported.  Use the cursor library.";
			CC_log_error(func, "", conn);
		}
		return SQL_ERROR;

	case SQL_USE_BOOKMARKS:

		if (stmt) stmt->options.use_bookmarks = vParam;
		if (conn) conn->stmtOptions.use_bookmarks = vParam;
		break;

    default:
		{
		char option[64];

		if (stmt) 
		{
			stmt->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
			stmt->errormsg = "Unknown statement option (Set)";
			sprintf(option, "fOption=%d, vParam=%ld", fOption, vParam);
			SC_log_error(func, option, stmt);
		}
		if (conn) 
		{
			conn->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
			conn->errormsg = "Unknown statement option (Set)";
			sprintf(option, "fOption=%d, vParam=%ld", fOption, vParam);
			CC_log_error(func, option, conn);
		}

        return SQL_ERROR;
		}
    }

	if (changed)
	{
		if (stmt) 
		{
			stmt->errormsg = "Requested value changed.";
			stmt->errornumber = STMT_OPTION_VALUE_CHANGED;
		}
		if (conn) 
		{
			conn->errormsg = "Requested value changed.";
			conn->errornumber = STMT_OPTION_VALUE_CHANGED;
		}
		return SQL_SUCCESS_WITH_INFO;
	}
	else
		return SQL_SUCCESS;
}
