
/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: gtkdialogs.c */
#include "gtkdialogs.h"

static int answer = ANSWER_YES;
static char tentry[MAX_ENTRY_LENGTH];

void yes_proc(GtkWidget* w, gpointer d)
{
 answer = ANSWER_YES;
 gtk_main_quit();
 gtk_widget_destroy((GtkWidget*)(d));
}

void no_proc(GtkWidget* w, gpointer d)
{
 answer = ANSWER_NO;
 gtk_main_quit();
 gtk_widget_destroy((GtkWidget*)(d));
}

gint delete_event_proc()
{
 answer = ANSWER_NO;
 strcpy(tentry, "");
 gtk_main_quit();
 return FALSE;
}

void ok_proc(GtkWidget* w, gpointer d)
{
 gtk_main_quit();
 gtk_widget_destroy((GtkWidget*)(d));
}

void entry_changed_proc(GtkWidget* w, gpointer d)
{
 strcpy(tentry,gtk_entry_get_text(GTK_ENTRY(w)));
}

void entry_proc(GtkWidget* w, gpointer d)
{
 strcpy(tentry,gtk_entry_get_text(GTK_ENTRY(w)));
 gtk_main_quit();
 gtk_widget_destroy((GtkWidget*)(d));
}

char* gtk_dialog_gettext_printf(const char* fmt, ...)
{
 va_list ap;
 char msg[MAX_MSG_LENGTH];
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 return gtk_dialog_gettext(msg);
}

char* gtk_dialog_gettext(const char* question)
{
 GtkWidget* dialog, *label, *button, *entry;
 strcpy(tentry, "");
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), "Enter text");
 gtk_widget_set_usize(dialog, 300, 100);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(question);
 entry = gtk_entry_new();
 gtk_entry_set_max_length(GTK_ENTRY(entry), MAX_ENTRY_LENGTH-2);
 gtk_signal_connect(GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(entry_proc), (gpointer)dialog);
 gtk_signal_connect(GTK_OBJECT(entry), "changed", GTK_SIGNAL_FUNC(entry_changed_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), entry, TRUE, TRUE, 0);
 gtk_widget_show(label);
 gtk_widget_show(entry);
 gtk_widget_grab_focus(entry);
 button = gtk_button_new_with_label("OK");
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(ok_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_show(button);
 gtk_widget_show(dialog);
 gtk_main();
 return tentry;
}


void gtk_dialog_printf(const char* fmt, ...)
{
 va_list ap;
 char msg[MAX_MSG_LENGTH];
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 gtk_dialog_mbox("Information", msg);
 va_end(ap);
}

void gtk_dialog_printf_big_with_title(const char* title, const char* fmt, ...)
{
 GtkWidget* dialog, *label, *button;
 char msg[MAX_MSG_LENGTH];
 va_list ap;
 va_start(ap,fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), title);
 gtk_widget_set_usize(dialog, 650, 350);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(msg);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button = gtk_button_new_with_label("OK");
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(ok_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button);
 gtk_widget_show(button);
 gtk_widget_show(dialog);
 gtk_main();
}

void gtk_dialog_printf_big(const char* fmt, ...)
{
 GtkWidget* dialog, *label, *button;
 char msg[MAX_MSG_LENGTH];
 va_list ap;
 va_start(ap,fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), "Long information");
 gtk_widget_set_usize(dialog, 650, 350);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(msg);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button = gtk_button_new_with_label("OK");
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(ok_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button);
 gtk_widget_show(button);
 gtk_widget_show(dialog);
 gtk_main();
}

void gtk_dialog_printf_with_title(const char* title, const char* fmt, ...)
{
 GtkWidget* dialog, *label, *button;
 char msg[MAX_MSG_LENGTH];
 va_list ap;
 va_start(ap,fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), title);
 gtk_widget_set_usize(dialog, 400, 150);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(msg);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button = gtk_button_new_with_label("OK");
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(ok_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button);
 gtk_widget_show(button);
 gtk_widget_show(dialog);
 gtk_main();
}

void gtk_dialog_mbox(const char* title, const char* msg)
{
 GtkWidget* dialog, *label, *button;
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), title);
 gtk_widget_set_usize(dialog, 400, 150);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(msg);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button = gtk_button_new_with_label("OK");
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(ok_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button);
 gtk_widget_show(button);
 gtk_widget_show(dialog);
 gtk_main();
}

int gtk_dialog_yes_no_printf(const char* fmt, ...)
{
 GtkWidget* dialog, *label, *button_yes, *button_no;
 char question[MAX_MSG_LENGTH];
 va_list ap;
 va_start(ap,fmt);
 vsprintf(question,fmt,ap);
 va_end(ap);
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), "Confirmation needed.");
 gtk_widget_set_usize(dialog, 400, 150);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(question);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button_yes = gtk_button_new_with_label("Yes");
 button_no  = gtk_button_new_with_label("No");
 gtk_signal_connect(GTK_OBJECT(button_yes), "clicked", GTK_SIGNAL_FUNC(yes_proc), (gpointer)dialog);
 gtk_signal_connect(GTK_OBJECT(button_no),  "clicked", GTK_SIGNAL_FUNC(no_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_yes, TRUE, TRUE, 0);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_no, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button_yes);
 gtk_widget_show(button_yes);
 gtk_widget_show(button_no);
 gtk_widget_show(dialog);
 gtk_main();
 return (answer==ANSWER_YES)?1:0;
}

int gtk_dialog_with_2_buttons(const char* question, char* but1, char* but2)
{
 GtkWidget* dialog, *label, *button_yes, *button_no;
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), "Confirmation needed.");
 gtk_widget_set_usize(dialog, 400, 150);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(question);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button_yes = gtk_button_new_with_label(but1);
 button_no  = gtk_button_new_with_label(but2);
 gtk_signal_connect(GTK_OBJECT(button_yes), "clicked", GTK_SIGNAL_FUNC(yes_proc), (gpointer)dialog);
 gtk_signal_connect(GTK_OBJECT(button_no),  "clicked", GTK_SIGNAL_FUNC(no_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_yes, TRUE, TRUE, 0);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_no, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button_yes);
 gtk_widget_show(button_yes);
 gtk_widget_show(button_no);
 gtk_widget_show(dialog);
 gtk_main();
 return (answer==ANSWER_YES)?1:0;
}

int gtk_dialog_yes_no(const char* question)
{
 GtkWidget* dialog, *label, *button_yes, *button_no;
 dialog = gtk_dialog_new();
 gtk_window_set_title(GTK_WINDOW(dialog), "Confirmation needed.");
 gtk_widget_set_usize(dialog, 400, 150);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label = gtk_label_new(question);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
 gtk_widget_show(label);
 button_yes = gtk_button_new_with_label("Yes");
 button_no  = gtk_button_new_with_label("No");
 gtk_signal_connect(GTK_OBJECT(button_yes), "clicked", GTK_SIGNAL_FUNC(yes_proc), (gpointer)dialog);
 gtk_signal_connect(GTK_OBJECT(button_no),  "clicked", GTK_SIGNAL_FUNC(no_proc), (gpointer)dialog);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_yes, TRUE, TRUE, 0);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_no, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_event_proc), (gpointer)dialog);
 gtk_widget_grab_focus(button_yes);
 gtk_widget_show(button_yes);
 gtk_widget_show(button_no);
 gtk_widget_show(dialog);
 gtk_main();
 return (answer==ANSWER_YES)?1:0;
}

