#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>
#include <utils/timestamp.h>

#include <time.h>

static void adjustment(struct tm* t)
{
/*
	Note PostgreSQL's year is _not_ 1900-based, but is an explicit full value.
	Also, month is one-based, _not_ zero-based.
*/
	++(t->tm_mon);
	t->tm_year += 1900;
}

PG_FUNCTION_INFO_V1(util_uuid_type);
Datum util_uuid_type(PG_FUNCTION_ARGS)
{
	uuid_p ptr = (uuid_p) PG_GETARG_POINTER(0);

	PG_RETURN_INT16(uuid_type(ptr));
}

PG_FUNCTION_INFO_V1(util_uuid_variant);
Datum util_uuid_variant(PG_FUNCTION_ARGS)
{
	uuid_p ptr = (uuid_p) PG_GETARG_POINTER(0);

	PG_RETURN_INT16(uuid_variant(ptr));
}

PG_FUNCTION_INFO_V1(util_uuid_timestamp);
Datum util_uuid_timestamp(PG_FUNCTION_ARGS)
{
	time_t tt;
	struct tm* t;
	Timestamp result;

	uuid_p ptr = (uuid_p) PG_GETARG_POINTER(0);

	tt = uuid_time(ptr, 0);
	t = localtime(&tt);

	adjustment(t);

	if (tm2timestamp(t, 0, 0, &result) != 0)
	{
		elog(ERROR, "Unable to decode TIMESTAMP");
	}

	PG_RETURN_TIMESTAMP(result);
}
