#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

/* in func */
PG_FUNCTION_INFO_V1(uuid_in);
Datum uuid_in(PG_FUNCTION_ARGS)
{
	uuid_p result;

	char* in = PG_GETARG_CSTRING(0);
	result = (uuid_p)palloc(sizeof(uuid_t));

	if(uuid_parse(in, result) < 0)
	{
		elog(ERROR, "%s is invalid UUID format!", in);
	}

	PG_RETURN_POINTER(result);
}

/* out func */
PG_FUNCTION_INFO_V1(uuid_out);
Datum uuid_out(PG_FUNCTION_ARGS)
{
	char* result = 0;

	uuid_p ptr = (uuid_p) PG_GETARG_POINTER(0);
	result = (char*)palloc(sizeof(char) * 40);

	uuid_unparse(ptr, result);

	PG_RETURN_CSTRING(result);
}
