#include <uuid.h>

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

int uuid_parse(const char in[], uuid_p uu)
{
	int 		i;
	const char	*cp;
	char		buf[3];

	if (strlen(in) != 36)
		return -1;
	for (i=0, cp = in; i <= 36; i++,cp++) {
		if ((i == 8) || (i == 13) || (i == 18) ||
		    (i == 23)) {
			if (*cp == '-')
				continue;
			else
				return -1;
		}
		if (i== 36)
			if (*cp == 0)
				continue;
		if (!isxdigit(*cp))
			return -1;
	}
	uu->time_low = strtoul(in, NULL, 16);
	uu->time_mid = strtoul(in+9, NULL, 16);
	uu->time_hi_and_version = strtoul(in+14, NULL, 16);
	uu->clock_seq = strtoul(in+19, NULL, 16);
	cp = in+24;
	buf[2] = 0;
	for (i=0; i < 6; i++) {
		buf[0] = *cp++;
		buf[1] = *cp++;
		uu->node[i] = strtoul(buf, NULL, 16);
	}
	
	return 0;
}
