<?php
/* application.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/* turn on verbose error reporting (15) to see all warnings and errors */
//error_reporting(15);

/* define a generic object */
class object {};

/* setup the configuration object */
$CFG = new object;

$CFG->dbms = "pgsql";	// PostgreSQL
//$CFG->dbms = "mysql";	// MySQL

$CFG->myname = "PgMarket 1.5.2 (development)";

$CFG->wwwroot     = "/~pratesi/pgmarket";	// without an ending "/"
$CFG->dirroot     = "/home/pratesi/public_html/pgmarket";	// without an ending "/"
$CFG->firstpage   = "$CFG->wwwroot" . "/firstpage.php";
$CFG->templatedir = "$CFG->dirroot" . "/templates/";	// with an ending "/"
$CFG->libdir      = "$CFG->dirroot" . "/lib";	// without an ending "/"
$CFG->libwww      = "$CFG->wwwroot" . "/lib";	// without an ending "/"
$CFG->localedir   = "$CFG->dirroot" . "/locale/";	// with an ending "/"
$CFG->productswww = "$CFG->wwwroot" . "/products/";	// with an ending "/"
$CFG->productsdir = "$CFG->dirroot" . "/products/";	// with an ending "/"
$CFG->images      = "$CFG->wwwroot" . "/images/";	// with an ending "/"
$CFG->wordlist    = "$CFG->libdir" . "/wordlist.txt";

$CFG->pnmpath     = "/usr/bin";	// without an ending "/"

$CFG->support     = "pratesi@localhost";	// "Technical support" at PgMarket
$subject_contact = "Contact us!";
$subject_cash_on_delivery = "New Order - Cash on Delivery";
$subject_credit_card = "New Order - Credit Card";
$CFG->seller_fullname = "Marco Pratesi";
$CFG->seller_email = "pratesi@localhost";

/* define database error handling behavior, since we are in development stages
 * we will turn on all the debugging messages to help us troubleshoot */
$DB_DEBUG = true;
$DB_DIE_ON_FAIL = true;

/* load up standard libraries */
require ("$CFG->libdir" . "/stdlib.inc.php");
require ("$CFG->libdir" . "/db_" . "$CFG->dbms" . ".inc.php");	// PHPLib...
require ("$CFG->libdir" . "/" . "$CFG->dbms" . "_queries.inc.php");
require ("$CFG->libdir" . "/pgmarket.inc.php");
require ("$CFG->libdir" . "/cart.inc.php");
require ("$CFG->libdir" . "/template.inc.php");
require ("$CFG->libdir" . "/misc_settings.inc.php");

/* setup some global variables */
$ME = qualified_me();

/* start up the sessions, to keep things clean and manageable we will just
 * use one array called SESSION to store our persistent variables.   */
session_start();
session_register("SESSION");

/* initialize the SESSION variable if necessary */
if (! isset($SESSION)) {
	$SESSION = array();
}

// Loaded modules
if (! isset($SESSION["frames_used"])) {
	$SESSION["frames_used"] = 1;
	$SESSION["catbrowser_target"] = "bodyframe";
//	$SESSION["frames_used"] = 0;
//	$SESSION["catbrowser_target"] = "main";
}
if (! isset($SESSION["layersmenu_used"]))
	$SESSION["layersmenu_used"] = 1;
$SESSION["brand_used"] = 1;
$SESSION["iva_used"] = 1;
//$SESSION["iva_value"] = 0;	// not significant if IVA is used
$IVA = "VAT";
$SESSION["weight_used"] = 1;
$SESSION["delivery_used"] = 1;

$SESSION["max_file_size_import"] = 10000000;	// upload of import files
$SESSION["max_file_size_images"] = 500000;	// upload of product images

session_register("CART");

/* initialize the CART objct if necessary */
if (! isset($CART)) {
	$CART = new Cart;
}

//$yes = "si";
$yes = "yes";
// choose the default language if not set
if (! isset($SESSION["lang"])) {
//	$SESSION["lang"] = "it";
	$SESSION["lang"] = "us";
}
$CFG->globalerror = "$CFG->localedir" . $SESSION["lang"] . "/global-error.inc.php";
$CFG->localelangdir = "$CFG->localedir" . $SESSION["lang"];

//include ($CFG->global);

//$currency = "Lit";
$currency = "$";
$SESSION["price_must_be_integer"] = 0;
	// 1 --> the price must be integer (Italian Lit, for example)
	// 0 --> the price can be float (US Dollars, for example)
function print_formatted_price($price) {
	global $currency, $lire2euro;
//	echo $currency . " " . number_format ($price, 0, ",", ".");
	echo $currency . " " . number_format ($price, 2, ".", ",");
}
function formatted_price($price) {
	global $currency, $lire2euro;
//	return $currency . " " . number_format ($price, 0, ",", ".");
	return $currency . " " . number_format ($price, 2, ".", ",");
}
function formatted_price_text($price) {
	global $currency, $lire2euro;
//	return $currency . " " . number_format ($price, 0, ",", ".");
	return $currency . " " . number_format ($price, 2, ".", ",");
}

$weightunity = "Kg";
$SESSION["weightmax"] = 10000.0;
function print_formatted_weight($weight) {
//	echo number_format ($weight, 2, ",", ".");
	echo number_format ($weight, 2, ".", ",");
}
function formatted_weight($weight) {
//	return number_format ($weight, 2, ",", ".");
	return number_format ($weight, 2, ".", ",");
}

$ordersdb["Customer"]	= "Customer      :";
$ordersdb["Phone"]	= "Phone Contact :";
$ordersdb["Address"]	= "Address       :";
$ordersdb["Cash_On_Delivery"] = "Cash on Delivery";
$ordersdb["Order"] = "Order";
$ordersdb["Username"] = "Username";
$ordersdb["Date"] = "Date";
$ordersdb["Comments"] = "Comments";
$ordersdb["TOTAL"] = "TOTAL";
$ordersdb["Product"] = "Product";
$ordersdb["Unit_Price"] = "Unit price";
$ordersdb["Number_of_items"] = "Number of items";
$ordersdb["Delivery"] = "Delivery";

$contact["NameOrCompanyName"]	= "Name (Company Name): ";
$contact["Address"] = "Address:";
$contact["Phone"]		= "Phone:        ";
$contact["Fax"]			= "Fax:          ";
$contact["MobilePhone"]		= "Mobile Phone: ";
$contact["EMail"]		= "E-Mail:       ";
$contact["AuthData"]		= "Authorization for data handling: ";
$contact["AuthAdvert"]		= "Acceptance of advertising material: ";
$contact["Message"]		= "Message:";

$adminday[1] = "Monday";
$adminday[2] = "Tuesday";
$adminday[3] = "Wednesday";
$adminday[4] = "Thursday";
$adminday[5] = "Friday";
$adminday[6] = "Saturday";
$adminday[0] = "Sunday";

$adminmonth[1] = "January";
$adminmonth[2] = "February";
$adminmonth[3] = "March";
$adminmonth[4] = "April";
$adminmonth[5] = "May";
$adminmonth[6] = "June";
$adminmonth[7] = "July";
$adminmonth[8] = "August";
$adminmonth[9] = "September";
$adminmonth[10] = "October";
$adminmonth[11] = "November";
$adminmonth[12] = "December";

?>
