<?
/* purchase_now.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();

$DOC_TITLE = $Checkout;
$template_to_show = "templates/purchase_now.ihtml";

/* form has been submitted */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors);

	if (empty($errormsg)) {
		save_orderinfo($HTTP_POST_VARS);
		$qid = get_cart_items();
		
		$template_to_show = "templates/purchase_confirmation.ihtml";
	}
} else {
	$user = load_userinfo();
	$frm["customer"] = $user->firstname . " " . $user->lastname;
	$frm["contact"] = $user->phone;
	$frm["address"] = $user->address;	
	$frm["number"] = $user->number;
	$frm["city"] = $user->city;
	$frm["state"] = $user->state;
	$frm["zip_code"] = $user->zip_code;
}

if ($info = load_orderinfo()) {
	$customer = $info->customer;
	$contact = $info->contact;
	$address = $info->address;
	$number = $info->number;
	$city = $info->city;
	$state = $info->state;
	$zip_code = $info->zip_code;
	$comments = $info->comments;
}

include("$CFG->templatedir"."header.ihtml");
include("$CFG->templatedir"."form_header.ihtml");
include($template_to_show);
include("$CFG->templatedir"."footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {
/* validate the billing information form, and return the error messages in a
 * string.  if the string is empty, then there are no errors */

	global $CFG, $SESSION;
	include ($CFG->global);

	$errors = new Object;
	$msg = "";

	validate_customer($frm["customer"], &$errors, &$msg);
	validate_contact($frm["contact"], &$errors, &$msg);
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_state($frm["state"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_comments($frm["comments"], &$errors, &$msg);

	return $msg;
}

function load_userinfo() {
/* this function returns an object containing the user's information (name,
 * address, etc.  we will use this information to pre-populate the billing
 * information fields of the form */

	global $SESSION;
 
	$qid = db_query("SELECT firstname, lastname, phone,
				address, number, city, state, zip_code
			FROM users
			WHERE username = '{$SESSION["user"]["username"]}'");
	return db_fetch_object($qid, 0);
}

?>
