/*
 * Database.java
 *
 * Created on 30 de julio de 2002, 15:49
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 * This is a Database information class.
 *
 * @author  nestor
 */
public class Database extends DBObject {
    protected static MainConnection connection = null;
    
    private String encoding = new String();
    private String template = new String();
    private String location = new String();
    private boolean isTemplate = false;
    private boolean allowConnections = false;
    
    /** Creates a new instance of Database */
    public Database(MainConnection _connection) {
        super(null);
        setConnection(_connection);
        if(validate()) {
            search( getConnection().getDatabaseName());
        }
    }
    
    public Database(MainConnection _connection, String _name) {
        super(null);
        setConnection(_connection);
        search(_name);
    }
    
    /** Drops the database
     */
    public boolean Drop(){
        boolean retorno = false;
        if (validate()){
            try{
                retorno = getConnection().executeUpdate("DROP DATABASE " + getName()) > 0;
            } catch (SQLException e){
                JOptionPane.showMessageDialog(null, e.getMessage(), "Can't drop object", JOptionPane.ERROR_MESSAGE);
            }
        }
        return retorno;
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database, it's used in script generation.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP DATABASE ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object. It's used in script generation.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE DATABASE ");
        retorno.append(getName()).append(" ");
        
        if ((getLocation().length() > 0)
        || (getTemplate().length() > 0)
        || (getEncoding().length() > 0)){
            retorno.append("WITH ");
            if(getLocation().length() > 0){
                retorno.append("LOCATION='").append(getLocation()).append("' ");
            }
            if(getTemplate().length() > 0){
                retorno.append("TEMPLATE=").append(getTemplate()).append(" ");
            }
            if(getEncoding().length() > 0){
                retorno.append("ENCODING=").append(getEncoding()).append(" ");
            }
        }
        
        retorno.append(";\n ");
        
        return retorno.toString();
    }
    
    /** Find the object asociated with the name.
     * @param _name name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        if(validate()){
            try{
                initialize();
                ResultSet rs = getConnection().getQueryGenerator().getDatabases(_name);
                if ((rs != null) && (rs.next())){
                    setName(rs.getString("database_name"));
                    setDBA(rs.getString("database_dba"));
                    setTemplate(rs.getBoolean("database_template"));
                    setAllowConnections(rs.getBoolean("database_allowconn"));
                    retorno = true;
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return retorno;
    }
    
    protected void initialize() {
        super.initialize();
        isTemplate = false;
        allowConnections = false;
    }
    
    // ------------ SET AND GET  ---------
    public boolean isTemplate(){
        return isTemplate;
    }
    
    public boolean allowConnections(){
        return allowConnections;
    }
    public User getDBA(){
        return getCreator();
    }
    
    public String getEncoding(){
        return encoding;
    }
    public String getTemplate(){
        return template;
    }
    
    public String getLocation(){
        return location;
    }
    
    public MainConnection getConnection(){
        return connection;
    }
    public static MainConnection getMainConnection(){
        return connection;
    }
    
    public boolean validate(){
        return connection != null;
    }
    
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
    // ------------  PRIVATE METHODS -----------
    private static void setConnection(MainConnection _connection){
        connection = _connection;
    }
    
    private void setDBA(String _user){
        setCreator(new User(this, _user));
    }
    private void setTemplate(boolean _isTemplate){
        isTemplate = _isTemplate;
    }
    private void setAllowConnections(boolean _allowConnections){
        allowConnections = _allowConnections;
    }
    
    private void setEncoding(String _encoding){
        if(_encoding != null){
            encoding = _encoding;
        } else {
            encoding = new String();
        }
    }
    private void setTemplate(String _template){
        if(_template != null){
            template = _template;
        } else {
            template = new String();
        }
    }
    private void setLocation(String _location){
        if(_location != null){
            location = _location;
        } else {
            location = new String();
        }
    }
}
