/*
 * GroupList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package components.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class GroupList extends TreeInfo {
    
    /** Creates a new instance of GroupList */
    public GroupList(RootElement  source) {
        super(source);
        setIcon("/images/group.gif");
    }
    
    public Object getOID() {
        return toString();
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs = getConnection().getQueryGenerator().getGroupNames();
            while((rs != null) && rs.next()){
                addProperty(new Element(this, new Group(getDatabase(), rs.getString("group_name"))));
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
        }
    }
    
    public String toString(){
        return "Groups";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
