/*
 * TreeControlModel.java
 *
 * Created on 23 de julio de 2002, 12:01
 */

package components;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import pgclibrary.dataaccess.*;
import pgclibrary.objects.*;
import components.treeObjects.*;
import pgclibrary.utilities.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class TreeControlModel implements TreeModel {
    private RootElement rootDatabase;
    private Vector treeModelListeners = new Vector();
    
    public TreeControlModel(RootElement rootData){
        rootDatabase = rootData;
    }
    
    public void setNewRoot(RootElement rootData) {
        rootDatabase = rootData;
        fireTreeStructureChanged();
    }
    
    public void fireTreeStructureChanged() {
        int len = treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent(this, new Object[] {rootDatabase});
        for (int i = 0; i < len; i++) {
            ((TreeModelListener)treeModelListeners.elementAt(i)).
            treeStructureChanged(e);
        }
    }
    
    public void addTreeModelListener(TreeModelListener l) {
        treeModelListeners.addElement(l);
    }
    
    public Object getChild(Object parent, int index) {
        TreeInfo temp = (TreeInfo) parent;
        Object retorno = null;
        if ((index >= 0) && (index < temp.getSize())){
            retorno = temp.getProperties().get(index);
        }
        return retorno;
    }
    
    public int getChildCount(Object parent) {
        TreeInfo temp = (TreeInfo) parent;
        return temp.getSize();
    }
    
    public int getIndexOfChild(Object parent, Object child) {
        TreeInfo temp = (TreeInfo) parent;
        return temp.getPropertyIndex((TreeInfo) child);
    }
    
    public Object getRoot() {
        return rootDatabase;
    }
    
    public boolean isLeaf(Object node) {
        TreeInfo temp = (TreeInfo) node;
        if(!temp.isInitialized()){
            return false;
        } else {
            return temp.getSize() == 0;
        }
    }
    
    public void removeTreeModelListener(TreeModelListener l) {
        treeModelListeners.removeElement(l);
    }
    
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}
