/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;

public class TableIndex
extends DBObject {
    private boolean clustered = false;
    private boolean unique = false;
    private boolean primary = false;
    private Vector columns = null;
    private String description = null;

    public TableIndex(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(" DROP INDEX ");
        stringBuffer.append(this.getName()).append(";\n");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPrimary()) {
            stringBuffer.append("CONSTRAINT ");
            stringBuffer.append(this.getName());
            stringBuffer.append(" PRIMARY KEY (");
            stringBuffer.append(this.getColumnsText());
            stringBuffer.append(" ) ");
        } else {
            stringBuffer.append("CREATE ");
            if (this.isUnique()) {
                stringBuffer.append("UNIQUE ");
            }
            stringBuffer.append("INDEX ");
            stringBuffer.append(this.getName());
            stringBuffer.append(" ON ");
            stringBuffer.append(this.getOwner().getName());
            stringBuffer.append(" ( ");
            stringBuffer.append(this.getColumnsText());
            stringBuffer.append(" );");
        }
        stringBuffer.append(this.getCommentSQL());
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            ResultSet resultSet = this.getConnection().getQueryGenerator().getIndex(string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("index_name"));
                this.setClustered(resultSet.getBoolean("index_cluster"));
                this.setUnique(resultSet.getBoolean("index_unique"));
                this.setPrimary(resultSet.getBoolean("index_primary"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.clustered = false;
        this.unique = false;
        this.primary = false;
        this.columns = null;
        this.description = null;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet resultSet = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (resultSet != null && resultSet.next()) {
                    TableColumn tableColumn = new TableColumn(this, resultSet.getString("column_name"));
                    this.columns.add(tableColumn);
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return this.columns;
    }

    public String getColumnsText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getColumns().size()) {
            TableColumn tableColumn = (TableColumn)this.columns.get(n);
            stringBuffer.append(tableColumn.getName());
            if (n < this.columns.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getColumnIndex(String string) {
        string = string.toUpperCase();
        int n = -1;
        if (string != null) {
            int n2 = 0;
            while (n2 < this.getColumns().size() && n < 0) {
                TableColumn tableColumn = (TableColumn)this.columns.get(n2);
                if (tableColumn.getName().toUpperCase().equals(string)) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    private String getCommentSQL() {
        String string = new String();
        String string2 = this.getDescription();
        if (string2 != null && string2.length() > 0) {
            string = "COMMENT ON INDEX " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return string;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setClustered(boolean bl) {
        this.clustered = bl;
    }

    private void setUnique(boolean bl) {
        this.unique = bl;
    }

    private void setPrimary(boolean bl) {
        this.primary = bl;
    }

    private void setDescription(String string) {
        this.description = string != null ? string : new String();
    }
}

