/*
 * Decompiled with CFR 0.152.
 */
package components.group;

import components.SQLTable;
import components.SQLTableModel;
import components.group.UsersPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.Group;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class UsersPanel
extends JPanel {
    private Group user_object = null;
    private SQLTable data_table = new SQLTable();
    private UsersPanelListener listener = new UsersPanelListener(this);

    public UsersPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_table);
        this.data_table.setModel(sQLTableModel);
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        ((SQLTableModel)this.data_table.getModel()).setDataSource(this.getUsersTable());
        this.repaint();
    }

    public void refresh(Group group) {
        this.user_object = group;
        this.refresh();
    }

    public Group getGroup() {
        return this.user_object;
    }

    public UsersPanelListener getListener() {
        return this.listener;
    }

    public void newUsers() {
    }

    public void deleteUsers() {
    }

    public dataSource getUsersTable() {
        dataSourceVector dataSourceVector2 = new dataSourceVector();
        dataSourceVector2.addColumnName("Name");
        dataSourceVector2.addColumnName("Valid Until");
        dataSourceVector2.addColumnSize(10);
        dataSourceVector2.addColumnSize(20);
        if (this.user_object != null) {
            Vector vector = this.user_object.getUsers();
            int n = 0;
            while (n < vector.size()) {
                User user = (User)vector.get(n);
                Vector<String> vector2 = new Vector<String>();
                vector2.add(user.getName());
                if (user.getValidLimit() != null) {
                    vector2.add(Utilities.formatDate(user.getValidLimit()));
                } else {
                    vector2.add("");
                }
                dataSourceVector2.addElement(vector2);
                ++n;
            }
        }
        return dataSourceVector2;
    }
}

