/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.treeObjects;

import java.util.Vector;
import javax.swing.ImageIcon;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.Database;

public abstract class TreeInfo {
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/shim.gif"));
    protected Vector errors = new Vector();
    private Vector properties = null;
    private TreeInfo owner = null;

    public TreeInfo(TreeInfo _owner) {
        this.owner = _owner;
    }

    public abstract void rebuildProperties();

    public abstract Object getOID();

    public boolean validate() {
        this.errors = new Vector();
        if (Database.getMainConnection() == null) {
            this.errors.add("No initializations parameters defined.");
            this.errors.add("See the connection parameters.");
        } else if (!Database.getMainConnection().isConnected()) {
            this.errors.add("The connection is not initialized.");
            this.errors.add("See the connection parameters.");
        }
        return this.errors.size() == 0;
    }

    public void refreshProperties() {
        this.properties = null;
    }

    public Vector getProperties() {
        if (this.properties == null) {
            this.rebuildProperties();
        }
        return this.properties;
    }

    public int getPropertyIndex(TreeInfo _prop) {
        Vector props = this.getProperties();
        int retorno = -1;
        if (_prop != null) {
            int i = 0;
            while (i < props.size() && retorno < 0) {
                TreeInfo obj = (TreeInfo)props.get(i);
                if (_prop.equals(obj)) {
                    retorno = i;
                }
                ++i;
            }
        }
        return retorno;
    }

    public void addProperty(TreeInfo _prop) {
        if (_prop != null) {
            if (this.properties == null) {
                this.properties = new Vector();
            }
            this.properties.add(_prop);
        }
    }

    public void removeProperty(TreeInfo _prop) {
        int idx;
        if (_prop != null && (idx = this.getPropertyIndex(_prop)) >= 0) {
            this.properties.remove(idx);
        }
    }

    public void removeAllProperties() {
        this.properties = new Vector();
    }

    public int getSize() {
        return this.getProperties().size();
    }

    public boolean isInitialized() {
        return this.properties != null;
    }

    public boolean equals(Object _obj) {
        TreeInfo obj;
        boolean retorno = false;
        if (_obj.getClass() == this.getClass() && (obj = (TreeInfo)_obj).getOID() == this.getOID()) {
            retorno = true;
        }
        return retorno;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    protected void setIcon(ImageIcon _icon) {
        this.icon = _icon;
    }

    protected void setIcon(String _icon) {
        this.icon = new ImageIcon(this.getClass().getResource(_icon));
    }

    public Vector getErrors() {
        return this.errors;
    }

    public String getErrorString() {
        StringBuffer retorno = new StringBuffer();
        int i = 0;
        while (i < this.errors.size()) {
            retorno.append((String)this.errors.get(i));
            retorno.append("\n");
            ++i;
        }
        return retorno.toString();
    }

    public TreeInfo getOwner() {
        return this.owner;
    }

    public MainConnection getConnection() {
        return Database.getMainConnection();
    }
}

