/*
 * TableEditRecordDialog.java
 *
 * Created on 8 de agosto de 2002, 13:28
 */

package components.table;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import pgclibrary.dataaccess.*;
import pgclibrary.objects.*;
import pgclibrary.utilities.*;
import java.util.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class TableEditRecordDialog  extends JDialog {
    Table table = null;
    Vector columns = new Vector();
    Vector index_data = new Vector();
    
    /** Creates a new instance of TableEditRecordDialog */
    public TableEditRecordDialog(Table _table, Vector iniValues) {
        this.setTitle("Edit record");
        table = _table;
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e) {
                close();
            }});
            
            getContentPane().add(getContents(iniValues), BorderLayout.CENTER);
            getContentPane().add(getButtons(), BorderLayout.SOUTH);
            
            setModal(true);
            pack();
    }
        
    
    private Component getContents(Vector iniValues){
        TableIndex idx = (TableIndex) table.getPrimaryKeys().get(0);
        
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
        
        for(int i= 0; i<table.getColumns().size(); i++){
            TableColumn tc = (TableColumn) table.getColumns().get(i);
            
            JTextComponent tf = null;
            if(tc.getSize() < 40) {
                tf = new JTextField(20);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", tf));
            } else {
                tf = new JTextArea(3,20);
                JScrollPane jsp = new JScrollPane(tf);
                jsp.setPreferredSize(tf.getPreferredSize());
                jsp.setAutoscrolls(false);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", jsp));
            }
            
            tf.setText((String) iniValues.get(i));
            if(idx.getColumnIndex(tc.getName()) >= 0){
                index_data.add((String) iniValues.get(i));
            }
            
            columns.add(tf);
        }
        return panel;
    }
    
    private Component getButtons(){
        TableEditRecordDialogListener listener = new TableEditRecordDialogListener(this);
        
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        
        panel.add(Box.createHorizontalGlue());
        
        JButton okey = new JButton("Update");
        okey.setActionCommand(TableEditRecordDialogListener.AC_UPDATE);
        okey.addActionListener(listener);
        panel.add(okey);
        
        panel.add(Box.createHorizontalStrut(5));
        
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand(TableEditRecordDialogListener.AC_CANCEL);
        cancel.addActionListener(listener);
        panel.add(cancel);
        
        panel.add(Box.createHorizontalGlue());
        
        return panel;
    }
    
    protected void update(){
        Vector data = new Vector();
        for(int i=0; i<columns.size(); i++){
            data.add(((JTextComponent) columns.get(i)).getText());
        }
        data.addAll(index_data);
        try {
            table.updateRecord(data);
            dispose();
        } catch (SQLException e){
            JOptionPane.showMessageDialog(this, e.getMessage() , "Message", JOptionPane.INFORMATION_MESSAGE);
        }
    }
    protected void close(){
        dispose();
    }
}

class TableEditRecordDialogListener implements ActionListener {
    public static final String AC_CANCEL = "cancel";
    public static final String AC_UPDATE = "update";
    
    private TableEditRecordDialog frame = null;
    
    /** Creates a new instance of PrincipalFrame_listener */
    public TableEditRecordDialogListener(TableEditRecordDialog _frame){
        frame = _frame;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        if(actionEvent.getActionCommand().equals(AC_CANCEL)){
            frame.close();
        }
        if(actionEvent.getActionCommand().equals(AC_UPDATE)){
            frame.update();
        }
    }
}



