/*
 * Decompiled with CFR 0.152.
 */
package components.database;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.Database;
import pgclibrary.utilities.SUtilities;
import pgclibrary.utilities.Utilities;

public class DatabasePanel
extends JTabbedPane {
    Database database_object = null;
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextField encoding = new JTextField(20);
    JTextField location = new JTextField(20);
    JTextField template = new JTextField(20);
    JTextField istemplate = new JTextField(20);
    JTextField allowconn = new JTextField(20);
    JTextArea sql = new JTextArea();

    public DatabasePanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setDatabase(Database _database_object) {
        this.database_object = _database_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.oid.setEditable(false);
        this.name.setEditable(false);
        this.owner.setEditable(false);
        this.encoding.setEditable(false);
        this.location.setEditable(false);
        this.template.setEditable(false);
        this.istemplate.setEditable(false);
        this.allowconn.setEditable(false);
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("Database ID :", this.oid));
        general_panel.add(SUtilities.getHorPanel("Database Name :", this.name));
        general_panel.add(SUtilities.getHorPanel("Is Template :", this.istemplate));
        general_panel.add(SUtilities.getHorPanel("Allow Connections :", this.allowconn));
        general_panel.add(SUtilities.getHorPanel("Encoding :", this.encoding));
        general_panel.add(SUtilities.getHorPanel("Location :", this.location));
        general_panel.add(SUtilities.getHorPanel("Template :", this.template));
        general_panel.add(SUtilities.getHorPanel("Database DBA :", this.owner));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.oid.setText(String.valueOf(this.database_object.getOID()));
        this.name.setText(this.database_object.getName());
        this.owner.setText(this.database_object.getCreator().getName());
        this.istemplate.setText(Utilities.formatBoolean(this.database_object.isTemplate()));
        this.allowconn.setText(Utilities.formatBoolean(this.database_object.allowConnections()));
        this.sql.setText(this.database_object.getInsertSQL());
        this.encoding.setText(this.database_object.getEncoding());
        this.location.setText(this.database_object.getLocation());
        this.template.setText(this.database_object.getTemplate());
        this.repaint();
    }
}

