package components.sequence;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class SequencePanel extends JTabbedPane {
    Sequence sequence_object = null;
    
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField creator = new JTextField(20);
    JTextField description = new JTextField(20);
    JTextField increment = new JTextField(20);
    JTextField last = new JTextField(20);
    JTextField max = new JTextField(20);
    JTextField min = new JTextField(20);
    
    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public SequencePanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setSequence(Sequence _sequence_object){
        sequence_object = _sequence_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
    }
    
    public void refreshProperties(){
        refreshDefaultPanel();
    }
    
    private void insertDefaultTab() {
        oid.setEditable(false);
        name.setEditable(false);
        creator.setEditable(false);
        description.setEditable(false);
        increment.setEditable(false);
        last.setEditable(false);
        max.setEditable(false);
        min.setEditable(false);
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("Sequence ID :", oid));
        general_panel.add(SUtilities.getHorPanel("Sequence Name :", name));
        general_panel.add(SUtilities.getHorPanel("Creator :", creator));
        general_panel.add(SUtilities.getHorPanel("Description :",description));
        general_panel.add(SUtilities.getHorPanel("Increment by :", increment));
        general_panel.add(SUtilities.getHorPanel("Last Value :", last));
        general_panel.add(SUtilities.getHorPanel("Maximum Value :", max));
        general_panel.add(SUtilities.getHorPanel("Minimum Value :", min));
        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        oid.setText(String.valueOf(sequence_object.getOID()));
        name.setText(sequence_object.getName());
        sql.setText(sequence_object.getInsertSQL());
        creator.setText(sequence_object.getCreator().getName());
        description.setText(sequence_object.getDescription());
        increment.setText(String.valueOf(sequence_object.getIncrementBy()));
        last.setText(String.valueOf(sequence_object.getLastValue()));
        max.setText(String.valueOf(sequence_object.getMaxValue()));
        min.setText(String.valueOf(sequence_object.getMinValue()));
        repaint();
    }
}


