/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/util/struct/SnapshotDataBlock.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:31 $
 *
 */

package com.postgres.replic.util.struct;

import java.util.*;

public class SnapshotDataBlock implements  DataConst {
    private CommandType snapCommand;
    private String param;

    // Array list of SnapshotDataRow objects:
    private ArrayList dataArray = new ArrayList();

    public SnapshotDataBlock(CommandType snapCommand, String param)
    throws Exception {
        if (snapCommand == null || param == null) {
             throw new Exception("SnapshotDataBlock:: snapCommand == null || param == null: param="+param);
        }

        this.snapCommand = snapCommand;
        this.param = param;
    }

    public void addRow(SnapshotDataRow data) {
         dataArray.add(data);
    }

    public SnapshotDataRow getRow(int i) {
         return (SnapshotDataRow) dataArray.get(i);
    }

    public void remove(int i) {
         dataArray.remove(i);
    }

    public int size() {
        return dataArray.size();
    }

    public CommandType getCommand(){
        return snapCommand;
    }

    public void setCommand(){
        this.snapCommand = snapCommand;
    }

    public int getCommandInt(){
        return snapCommand.getCommand();
    }

    public String getParam(){
        return param;
    }

    public void setParam(String param ){
        this.param = param;
    }

    public long getParamLong() throws Exception {
        long rc = 0;
        try {
            rc = (new Long(param)).longValue();
        } catch (Exception e) {
            throw new Exception("SnapshotdataBlock::getParamLong: " + e.toString());
        }
        return rc;
    }

}
