/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;

public class Mapper
extends DataType {
    protected Project p;
    protected MapperType type = null;
    protected String classname = null;
    protected Path classpath = null;
    protected String from = null;
    protected String to = null;

    public void setType(MapperType type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.type = type;
    }

    public void setClassname(String classname) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.classname = classname;
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.p);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
    }

    public void setFrom(String from) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.from = from;
    }

    public void setTo(String to) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.to = to;
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.type != null || this.from != null || this.to != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    /*
     * WARNING - void declaration
     */
    public FileNameMapper getImplementation() throws BuildException {
        if (this.isReference()) {
            return this.getRef().getImplementation();
        }
        if (this.type == null && this.classname == null) {
            throw new BuildException("one of the attributes type or classname is required");
        }
        if (this.type != null && this.classname != null) {
            throw new BuildException("must not specify both type and classname attribute");
        }
        try {
            if (this.type != null) {
                this.classname = this.type.getImplementation();
            }
            Class<?> c = null;
            if (this.classpath == null) {
                c = Class.forName(this.classname);
            } else {
                AntClassLoader al = new AntClassLoader(this.p, this.classpath);
                c = al.loadClass(this.classname);
            }
            FileNameMapper m = (FileNameMapper)c.newInstance();
            m.setFrom(this.from);
            m.setTo(this.to);
            return m;
        }
        catch (BuildException be) {
            void t;
            throw t;
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    protected Mapper getRef() {
        Object o;
        if (!this.checked) {
            Stack<Mapper> stk = new Stack<Mapper>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.p);
        }
        if (!((o = this.ref.getReferencedObject(this.p)) instanceof Mapper)) {
            String msg = this.ref.getRefId() + " doesn't denote a mapper";
            throw new BuildException(msg);
        }
        return (Mapper)o;
    }

    public Mapper(Project p) {
        this.p = p;
    }

    public static class MapperType
    extends EnumeratedAttribute {
        private Properties implementations = new Properties();

        public String[] getValues() {
            return new String[]{"identity", "flatten", "glob", "merge", "regexp"};
        }

        public String getImplementation() {
            return this.implementations.getProperty(this.getValue());
        }

        public MapperType() {
            ((Hashtable)this.implementations).put("identity", "org.apache.tools.ant.util.IdentityMapper");
            ((Hashtable)this.implementations).put("flatten", "org.apache.tools.ant.util.FlatFileNameMapper");
            ((Hashtable)this.implementations).put("glob", "org.apache.tools.ant.util.GlobPatternMapper");
            ((Hashtable)this.implementations).put("merge", "org.apache.tools.ant.util.MergingMapper");
            ((Hashtable)this.implementations).put("regexp", "org.apache.tools.ant.util.RegexpPatternMapper");
        }
    }
}

