/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlLogger
implements BuildListener {
    private static final DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private Document doc;
    private Element buildElement;
    private Element targetElement;
    private Element taskElement;
    private long buildStartTime;
    private long targetStartTime;
    private long taskStartTime;
    private Stack targetTimeStack = new Stack();
    private Stack targetStack = new Stack();
    private Stack taskTimeStack = new Stack();
    private Stack taskStack = new Stack();

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void buildStarted(BuildEvent event) {
        this.buildStartTime = System.currentTimeMillis();
        this.doc = builder.newDocument();
        this.buildElement = this.doc.createElement(BUILD_TAG);
    }

    public void buildFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.buildStartTime;
        this.buildElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        if (event.getException() != null) {
            this.buildElement.setAttribute(ERROR_ATTR, event.getException().toString());
        }
        try {
            String outFilename = event.getProject().getProperty("XmlLogger.file");
            if (outFilename == null) {
                outFilename = "log.xml";
            }
            FileWriter out = new FileWriter(outFilename);
            out.write("<?xml:stylesheet type=\"text/xsl\" href=\"log.xsl\"?>\n\n");
            new DOMElementWriter().write(this.buildElement, out, 0, "\t");
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException exc) {
            throw new BuildException("Unable to close log file", exc);
        }
        this.buildElement = null;
    }

    public void targetStarted(BuildEvent event) {
        if (this.targetElement != null) {
            this.targetTimeStack.push(new Long(this.targetStartTime));
            this.targetStack.push(this.targetElement);
        }
        this.targetStartTime = System.currentTimeMillis();
        this.targetElement = this.doc.createElement(TARGET_TAG);
        this.targetElement.setAttribute(NAME_ATTR, event.getTarget().getName());
    }

    public void targetFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.targetStartTime;
        this.targetElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        if (this.taskElement == null) {
            this.buildElement.appendChild(this.targetElement);
        } else {
            this.taskElement.appendChild(this.targetElement);
        }
        this.targetElement = null;
        if (!this.targetStack.isEmpty()) {
            this.targetStartTime = (Long)this.targetTimeStack.pop();
            this.targetElement = (Element)this.targetStack.pop();
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this.taskElement != null) {
            this.taskTimeStack.push(new Long(this.taskStartTime));
            this.taskStack.push(this.taskElement);
        }
        this.taskStartTime = System.currentTimeMillis();
        this.taskElement = this.doc.createElement(TASK_TAG);
        String name = event.getTask().getClass().getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        this.taskElement.setAttribute(NAME_ATTR, name);
        this.taskElement.setAttribute(LOCATION_ATTR, event.getTask().getLocation().toString());
    }

    public void taskFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.taskStartTime;
        this.taskElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        this.targetElement.appendChild(this.taskElement);
        this.taskElement = null;
        if (!this.taskStack.isEmpty()) {
            this.taskStartTime = (Long)this.taskTimeStack.pop();
            this.taskElement = (Element)this.taskStack.pop();
        }
    }

    public void messageLogged(BuildEvent event) {
        Element messageElement = this.doc.createElement(MESSAGE_TAG);
        String name = "debug";
        switch (event.getPriority()) {
            case 0: {
                name = ERROR_ATTR;
                break;
            }
            case 1: {
                name = "warn";
                break;
            }
            case 2: {
                name = "info";
                break;
            }
            default: {
                name = "debug";
                break;
            }
        }
        messageElement.setAttribute(PRIORITY_ATTR, name);
        Text messageText = this.doc.createTextNode(event.getMessage());
        messageElement.appendChild(messageText);
        if (this.taskElement != null) {
            this.taskElement.appendChild(messageElement);
        } else if (this.targetElement != null) {
            this.targetElement.appendChild(messageElement);
        } else {
            this.buildElement.appendChild(messageElement);
        }
    }
}

