/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;

public class DefaultLogger
implements BuildLogger {
    private static int LEFT_COLUMN_SIZE = 12;
    protected static String lSep = System.getProperty("line.separator");
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel;
    private long startTime = System.currentTimeMillis();
    protected boolean emacsMode = false;

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = err;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error == null) {
            this.out.println(lSep + "BUILD SUCCESSFUL");
        } else {
            this.err.println(lSep + "BUILD FAILED" + lSep);
            if (error instanceof BuildException) {
                this.err.println(error.toString());
                Throwable nested = ((BuildException)error).getException();
                if (nested != null) {
                    nested.printStackTrace(this.err);
                }
            } else {
                error.printStackTrace(this.err);
            }
        }
        this.out.println(lSep + "Total time: " + DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel) {
            this.out.println(lSep + event.getTarget().getName() + ":");
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        PrintStream logTo;
        PrintStream printStream = logTo = event.getPriority() == 0 ? this.err : this.out;
        if (event.getPriority() <= this.msgOutputLevel) {
            if (event.getTask() != null) {
                String name = event.getTask().getTaskName();
                if (!this.emacsMode) {
                    String msg = "[" + name + "] ";
                    int i = 0;
                    while (i < LEFT_COLUMN_SIZE - msg.length()) {
                        logTo.print(" ");
                        ++i;
                    }
                    logTo.print(msg);
                }
            }
            logTo.println(event.getMessage());
        }
    }

    protected static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return Long.toString(minutes) + " minute" + (minutes == 1L ? " " : "s ") + Long.toString(seconds % 60L) + " second" + (seconds % 60L == 1L ? "" : "s");
        }
        return Long.toString(seconds) + " second" + (seconds % 60L == 1L ? "" : "s");
    }
}

