""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from pgmlgraph import *

class PgmlGraphLdb(PgmlGraph):
	
	def _write_ldb(self, vtable, output):
		vtable.tag = 1
		for (label, mvrel) in vtable.items(): # mvrel : map of relations
			if self._label_dir(label) == '1':
				for vrel in mvrel.values():
					for (label, mvt) in vrel.items():
						if self._label_dir(label) == '0':
							for t in mvt.values():
								if not t.tag:
									self._write_ldb(t, output)
		vtable.object.write_ldb(output)

		
	def write_ldb(self, output):
		self.clear_tags()
		for vtable in self.get_tables().values():
			if not vtable.tag:
				self._write_ldb(vtable, output)
