/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GCLayout
implements LayoutManager2 {
    public static boolean debug;
    private int numGrowCols;
    private int numGrowRows;
    private int minW;
    private int minH;
    private int prefW;
    private int prefH;
    public static final int LG_GAP = -1;
    public static final int SM_GAP = 2;
    private ArrayListInfo[] rows;
    private ArrayListInfo[] cols;
    private Grid[][] grids = null;
    private final HashMap<Component, String> compNames = new HashMap();

    @Override
    public void invalidateLayout(Container target) {
        this.grids = null;
        this.rows = null;
        this.cols = null;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.addLayoutComponent((String)constraints, comp);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name != null) {
            this.compNames.put(comp, name);
        }
        this.invalidateLayout(null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.compNames.remove(comp);
        this.invalidateLayout(null);
    }

    private void fillOutGrid(Container parent) {
        Grid grid;
        int i;
        Component[] comps = parent.getComponents();
        CompInfo compInfo = new CompInfo(2);
        int gridW = 0;
        int gridH = 0;
        for (i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            String compName = this.compNames.get(comp);
            if (compName != null) {
                compInfo.update(compName);
            }
            if (compInfo.x > gridW) {
                gridW = compInfo.x;
            }
            if (compInfo.y > gridH) {
                gridH = compInfo.y;
            }
            compInfo.next();
        }
        ArrayListInfo[] safeRows = this.rows = new ArrayListInfo[++gridH];
        i = 0;
        while (i < gridH) {
            safeRows[i++] = new ArrayListInfo();
        }
        ArrayListInfo[] safeCols = this.cols = new ArrayListInfo[++gridW];
        i = 0;
        while (i < gridW) {
            safeCols[i++] = new ArrayListInfo();
        }
        Grid[][] safeGrids = this.grids = new Grid[gridW][gridH];
        compInfo = new CompInfo(2);
        for (i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            String compName = this.compNames.get(comp);
            if (compName != null) {
                compInfo.update(compName);
            }
            safeGrids[compInfo.x][compInfo.y] = grid = new Grid(comp, compInfo, gridW, gridH);
            if (grid.xSpan + compInfo.x > gridW || grid.ySpan + compInfo.y > gridH) {
                throw new RuntimeException("Component " + grid.comp + " goes past edge of grid: " + this.gridStr());
            }
            safeCols[compInfo.x].growable |= compInfo.xGrow;
            safeRows[compInfo.y].growable |= compInfo.yGrow;
            if (safeCols[compInfo.x + grid.xSpan - 1].border < this.pixels(parent, compInfo.xBorder)) {
                safeCols[compInfo.x + grid.xSpan - 1].border = this.pixels(parent, compInfo.xBorder);
            }
            if (safeRows[compInfo.y + grid.ySpan - 1].border < this.pixels(parent, compInfo.yBorder)) {
                safeRows[compInfo.y + grid.ySpan - 1].border = this.pixels(parent, compInfo.yBorder);
            }
            if (grid.xSpan == 1) {
                if (safeCols[compInfo.x].minSize < grid.minSize.width) {
                    safeCols[compInfo.x].minSize = grid.minSize.width;
                }
                if (safeCols[compInfo.x].prefSize < grid.prefSize.width) {
                    safeCols[compInfo.x].prefSize = grid.prefSize.width;
                }
            }
            if (grid.ySpan == 1) {
                if (safeRows[compInfo.y].minSize < grid.minSize.height) {
                    safeRows[compInfo.y].minSize = grid.minSize.height;
                }
                if (safeRows[compInfo.y].prefSize < grid.prefSize.height) {
                    safeRows[compInfo.y].prefSize = grid.prefSize.height;
                }
            }
            compInfo.next();
        }
        safeCols[gridW - 1].border = 0;
        safeRows[gridH - 1].border = 0;
        this.numGrowCols = 0;
        int growPrefW = 0;
        this.minW = 0;
        for (i = 0; i < gridW; ++i) {
            this.minW += safeCols[i].minSize + safeCols[i].border;
            if (!safeCols[i].growable) continue;
            ++this.numGrowCols;
            if (safeCols[i].prefSize <= growPrefW) continue;
            growPrefW = safeCols[i].prefSize;
        }
        this.numGrowRows = 0;
        int growPrefH = 0;
        this.minH = 0;
        for (i = 0; i < gridH; ++i) {
            this.minH += safeRows[i].minSize + safeRows[i].border;
            if (!safeRows[i].growable) continue;
            ++this.numGrowRows;
            if (safeRows[i].prefSize <= growPrefH) continue;
            growPrefH = safeRows[i].prefSize;
        }
        for (i = 0; i < gridW; ++i) {
            for (int j = 0; j < gridH; ++j) {
                int newMinSize;
                int k;
                int numGrows;
                grid = safeGrids[i][j];
                if (grid == null) continue;
                if (grid.xSpan != 1) {
                    int gridMinW = 0;
                    int gridPrefW = 0;
                    numGrows = 0;
                    for (k = 0; k < grid.xSpan; ++k) {
                        if (safeCols[i + k].growable) {
                            ++numGrows;
                            gridPrefW += growPrefW;
                        } else {
                            gridPrefW += safeCols[i + k].prefSize;
                        }
                        gridPrefW += safeCols[i + k].border;
                        gridMinW += safeCols[i + k].minSize + safeCols[i + k].border;
                    }
                    if (numGrows == 0) {
                        throw new RuntimeException("Spanning components must span growable columns.");
                    }
                    if (gridPrefW < grid.prefSize.width) {
                        growPrefW = (grid.prefSize.width - (gridPrefW - numGrows * growPrefW) + (numGrows - 1)) / numGrows;
                    }
                    if (gridMinW < grid.minSize.width) {
                        gridMinW = grid.minSize.width - gridMinW;
                        for (k = 0; k < grid.xSpan; ++k) {
                            if (!safeCols[i + k].growable) continue;
                            if (safeCols[i + k].minSize < gridMinW / numGrows) {
                                newMinSize = gridMinW / numGrows;
                                gridMinW -= newMinSize - safeCols[i + k].minSize;
                                this.minW += newMinSize - safeCols[i + k].minSize;
                                safeCols[i + k].minSize = newMinSize;
                            }
                            --numGrows;
                        }
                    }
                }
                if (grid.ySpan == 1) continue;
                int gridMinH = 0;
                int gridPrefH = 0;
                numGrows = 0;
                for (k = 0; k < grid.ySpan; ++k) {
                    if (safeRows[j + k].growable) {
                        ++numGrows;
                        gridPrefH += growPrefH;
                    } else {
                        gridPrefH += safeRows[j + k].prefSize;
                    }
                    gridPrefH += safeRows[j + k].border;
                    gridMinH += safeRows[j + k].minSize + safeRows[j + k].border;
                }
                if (numGrows == 0) {
                    throw new RuntimeException("Spanning components must span growable rows.");
                }
                if (gridPrefH < grid.prefSize.height) {
                    growPrefH = (grid.prefSize.height - (gridPrefH - numGrows * growPrefH) + (numGrows - 1)) / numGrows;
                }
                if (gridMinH >= grid.minSize.height) continue;
                gridMinH = grid.minSize.height - gridMinH;
                for (k = 0; k < grid.ySpan; ++k) {
                    if (!safeRows[j + k].growable) continue;
                    if (safeRows[j + k].minSize < gridMinH / numGrows) {
                        newMinSize = gridMinH / numGrows;
                        gridMinH -= newMinSize - safeRows[j + k].minSize;
                        this.minH += newMinSize - safeRows[j + k].minSize;
                        safeRows[j + k].minSize = newMinSize;
                    }
                    --numGrows;
                }
            }
        }
        this.prefW = 0;
        for (i = 0; i < gridW; ++i) {
            if (safeCols[i].growable) {
                safeCols[i].prefSize = growPrefW;
            }
            this.prefW += safeCols[i].prefSize + safeCols[i].border;
        }
        this.prefH = 0;
        for (i = 0; i < gridH; ++i) {
            if (safeRows[i].growable) {
                safeRows[i].prefSize = growPrefH;
            }
            this.prefH += safeRows[i].prefSize + safeRows[i].border;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.grids == null) {
            this.fillOutGrid(parent);
        }
        Insets insets = parent.getInsets();
        return new Dimension(this.prefW + insets.left + insets.right, this.prefH + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.grids == null) {
            this.fillOutGrid(parent);
        }
        Insets insets = parent.getInsets();
        Dimension result = new Dimension(this.minW + insets.left + insets.right, this.minH + insets.top + insets.bottom);
        return result;
    }

    @Override
    public void layoutContainer(Container parent) {
        int i;
        boolean isLToR = parent.getComponentOrientation().isLeftToRight();
        if (this.grids == null) {
            this.fillOutGrid(parent);
        }
        if (this.grids == null) {
            this.fillOutGrid(parent);
        }
        Dimension pSize = parent.getSize();
        Insets insets = parent.getInsets();
        int usableSpace = pSize.width - (insets.left + insets.right);
        if (usableSpace < this.minW) {
            usableSpace = this.minW;
        }
        boolean usePrefs = usableSpace >= this.prefW;
        int extraSpace = usableSpace - (usePrefs ? this.prefW : this.minW);
        int extraNeeds = usePrefs ? this.numGrowCols : this.prefW - this.minW;
        int[] widths = new int[this.cols.length];
        for (i = 0; i < this.cols.length; ++i) {
            int addedSize;
            if (usePrefs) {
                addedSize = this.cols[i].growable ? extraSpace / extraNeeds-- : 0;
            } else if (extraNeeds == 0) {
                addedSize = 0;
            } else {
                addedSize = extraSpace * (this.cols[i].prefSize - this.cols[i].minSize) / extraNeeds;
                extraNeeds -= this.cols[i].prefSize - this.cols[i].minSize;
            }
            widths[i] = (usePrefs ? this.cols[i].prefSize : this.cols[i].minSize) + addedSize;
            extraSpace -= addedSize;
        }
        usableSpace = pSize.height - (insets.top + insets.bottom);
        if (usableSpace < this.minH) {
            usableSpace = this.minH;
        }
        usePrefs = usableSpace >= this.prefH;
        extraSpace = usableSpace - (usePrefs ? this.prefH : this.minH);
        extraNeeds = usePrefs ? this.numGrowRows : this.prefH - this.minH;
        int[] heights = new int[this.rows.length];
        for (i = 0; i < this.rows.length; ++i) {
            int addedSize;
            if (usePrefs) {
                addedSize = this.rows[i].growable ? extraSpace / extraNeeds-- : 0;
            } else if (extraNeeds == 0) {
                addedSize = 0;
            } else {
                addedSize = extraSpace * (this.rows[i].prefSize - this.rows[i].minSize) / extraNeeds;
                extraNeeds -= this.rows[i].prefSize - this.rows[i].minSize;
            }
            heights[i] = (usePrefs ? this.rows[i].prefSize : this.rows[i].minSize) + addedSize;
            extraSpace -= addedSize;
        }
        int yBase = insets.top;
        for (int j = 0; j < this.rows.length; ++j) {
            int xBase = insets.left;
            for (i = 0; i < this.cols.length; ++i) {
                Grid grid = this.grids[i][j];
                if (grid != null) {
                    int k;
                    int x = xBase;
                    int y = yBase;
                    int w = 0;
                    int h = 0;
                    for (k = 0; k < grid.xSpan; ++k) {
                        if (k != 0 && this.grids[i + k][j] != null) {
                            throw new RuntimeException("Component " + grid + " steps on component " + this.grids[i + k][j]);
                        }
                        w += widths[i + k];
                        if (k + 1 >= grid.xSpan) continue;
                        w += this.cols[i + k].border;
                    }
                    for (k = 0; k < grid.ySpan; ++k) {
                        if (k != 0 && this.grids[i][j + k] != null) {
                            throw new RuntimeException("Component " + grid + " steps on component " + this.grids[i][j + k]);
                        }
                        h += heights[j + k];
                        if (k + 1 >= grid.ySpan) continue;
                        h += this.rows[j + k].border;
                    }
                    if (w > grid.prefSize.width) {
                        switch (grid.fill & 3) {
                            case 0: {
                                x += (w - grid.prefSize.width) / 2;
                                w = grid.prefSize.width;
                                break;
                            }
                            case 1: {
                                w = grid.prefSize.width;
                                break;
                            }
                            case 2: {
                                x += w - grid.prefSize.width;
                                w = grid.prefSize.width;
                                break;
                            }
                        }
                    }
                    if (h > grid.prefSize.height) {
                        switch (grid.fill & 0xC) {
                            case 0: {
                                y += (h - grid.prefSize.height) / 2;
                                h = grid.prefSize.height;
                                break;
                            }
                            case 4: {
                                h = grid.prefSize.height;
                                break;
                            }
                            case 8: {
                                y += h - grid.prefSize.height;
                                h = grid.prefSize.height;
                                break;
                            }
                        }
                    }
                    grid.comp.setBounds(isLToR ? x : pSize.width + insets.left - insets.right - x - w, y, w, h);
                }
                xBase += widths[i] + this.cols[i].border;
            }
            yBase += heights[j] + this.rows[j].border;
        }
        this.rows = null;
        this.cols = null;
        this.grids = null;
    }

    private int pixels(Component parent, int size) {
        if (size == -1) {
            return parent.getFontMetrics(parent.getFont()).getHeight();
        }
        return size;
    }

    private String gridStr() {
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < this.grids[0].length; ++y) {
            for (int x = 0; x < this.grids.length; ++x) {
                sb.append(this.grids[x][y] == null || this.grids[x][y].comp == null ? "---" : this.grids[x][y].comp.getClass().getName() + ":" + this.grids[x][y].xSpan + "x" + this.grids[x][y].ySpan);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class CompInfo {
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int TOP = 4;
        public static final int BOTTOM = 8;
        public static final int HORIZ = 3;
        public static final int VERT = 12;
        private static final int FILL_CODE = 0;
        private static final int X_CODE = 1;
        private static final int XGROW_CODE = 2;
        private static final int XBORDER_CODE = 3;
        private static final int XSPAN_CODE = 4;
        private static final int Y_CODE = 5;
        private static final int YGROW_CODE = 6;
        private static final int YBORDER_CODE = 7;
        private static final int YSPAN_CODE = 8;
        private static final int SIZE_CODE = 9;
        private static final HashMap<String, Integer> codes = CompInfo.fillHashTable();
        public int x = 0;
        public int y = 0;
        public boolean xGrow = false;
        public boolean yGrow = false;
        public boolean minSize = false;
        public int xBorder;
        public int yBorder;
        public int xSpan = 1;
        public int ySpan = 1;
        public int fill = 15;

        private static HashMap<String, Integer> fillHashTable() {
            HashMap<String, Integer> res = new HashMap<String, Integer>();
            int val = 0;
            StringTokenizer tok = new StringTokenizer("fill x xGrow xBorder xSpan y yGrow yBorder ySpan sz");
            while (tok.hasMoreElements()) {
                res.put(tok.nextToken(), new Integer(val++));
            }
            return res;
        }

        public CompInfo(int inset) {
            this.xBorder = inset;
            this.yBorder = inset;
        }

        public final void next() {
            this.minSize = false;
            this.x += this.xSpan;
        }

        public void update(String desc) {
            boolean clearX = true;
            boolean clearY = true;
            if (desc == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(desc, "=,");
            while (st.hasMoreTokens()) {
                Integer res = codes.get(st.nextToken());
                if (res == null) {
                    throw new RuntimeException("GCLayout: Unknown param in \"" + desc + "\".");
                }
                String val = st.nextToken();
                block0 : switch (res) {
                    case 0: {
                        switch (val.charAt(0)) {
                            case 'l': {
                                this.fill = 1;
                                break block0;
                            }
                            case 'r': {
                                this.fill = 2;
                                break block0;
                            }
                            case 'h': {
                                this.fill = 3;
                                break block0;
                            }
                            case 't': {
                                this.fill = 4;
                                break block0;
                            }
                            case 'b': {
                                this.fill = 8;
                                break block0;
                            }
                            case 'v': {
                                this.fill = 12;
                                break block0;
                            }
                            case '0': {
                                this.fill = 0;
                                break block0;
                            }
                            case '1': {
                                this.fill = 15;
                            }
                        }
                        break;
                    }
                    case 1: {
                        int newX = Integer.parseInt(val);
                        if (clearY && newX == 0 && this.x != 0) {
                            ++this.y;
                        }
                        this.x = newX;
                        clearX = false;
                        break;
                    }
                    case 3: {
                        switch (val.charAt(0)) {
                            case 's': {
                                this.xBorder = 2;
                                break block0;
                            }
                            case 'l': {
                                this.xBorder = -1;
                                break block0;
                            }
                        }
                        this.xBorder = Integer.parseInt(val);
                        break;
                    }
                    case 2: {
                        this.xGrow = val.equals("t");
                        break;
                    }
                    case 4: {
                        this.xSpan = Integer.parseInt(val);
                        break;
                    }
                    case 5: {
                        this.y = Integer.parseInt(val);
                        clearY = false;
                        if (!clearX) break;
                        this.x = 0;
                        break;
                    }
                    case 7: {
                        switch (val.charAt(0)) {
                            case 's': {
                                this.yBorder = 2;
                                break block0;
                            }
                            case 'l': {
                                this.yBorder = -1;
                                break block0;
                            }
                        }
                        this.yBorder = Integer.parseInt(val);
                        break;
                    }
                    case 6: {
                        this.yGrow = val.equals("t");
                        break;
                    }
                    case 8: {
                        this.ySpan = Integer.parseInt(val);
                        break;
                    }
                    case 9: {
                        switch (val.charAt(0)) {
                            case '0': {
                                this.minSize = true;
                                break block0;
                            }
                            case '1': {
                                this.minSize = false;
                            }
                        }
                    }
                }
            }
        }
    }

    private static class ArrayListInfo {
        public boolean growable = false;
        public int minSize = 0;
        public int prefSize = 0;
        public int border = 0;

        private ArrayListInfo() {
        }
    }

    private static class Grid {
        public final Dimension prefSize;
        public final Dimension minSize;
        public final Component comp;
        public final int xSpan;
        public final int ySpan;
        public final int fill;

        public Grid(Component comp, CompInfo compInfo, int gridW, int gridH) {
            this.comp = comp;
            this.minSize = comp.getMinimumSize();
            Dimension dimension = this.prefSize = compInfo.minSize ? this.minSize : comp.getPreferredSize();
            if (debug) {
                System.err.println("COMP: " + comp.getClass().getName() + " (" + comp.getName() + "): " + this.minSize + "/" + this.prefSize);
            }
            if (this.prefSize.width < this.minSize.width) {
                this.minSize.width = this.prefSize.width;
            }
            if (this.prefSize.height < this.minSize.height) {
                this.minSize.height = this.prefSize.height;
            }
            this.xSpan = compInfo.xSpan;
            this.ySpan = compInfo.ySpan;
            this.fill = compInfo.fill;
        }
    }
}

