/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.speex;

import java.io.IOException;
import java.io.InputStream;
import org.igoweb.util.speex.BitIoError;
import org.xiph.speex.Bits;

public class BitInputStream
extends Bits {
    private final InputStream in;
    private byte curVal;
    private int bitOffset = 8;

    public BitInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void advance(int numBits) {
        int skipAmt = (numBits += this.bitOffset) >> 3;
        if (skipAmt > 0) {
            if (skipAmt > 1) {
                try {
                    this.in.skip(skipAmt - 1);
                }
                catch (IOException excep) {
                    throw new BitIoError(excep.toString());
                }
            }
            this.bitOffset = numBits & 7;
            if (this.bitOffset == 0) {
                this.bitOffset = 8;
            } else {
                this.fillCurVal();
            }
        }
    }

    public void sync() {
        this.bitOffset = 8;
    }

    @Override
    public int unpack(int nbBits) {
        int d = 0;
        while (--nbBits >= 0) {
            if (this.bitOffset == 8) {
                this.fillCurVal();
                this.bitOffset = 0;
            }
            d = d << 1 | this.curVal >> 7 - this.bitOffset & 1;
            ++this.bitOffset;
        }
        return d;
    }

    @Override
    public int peek() {
        if (this.bitOffset == 8) {
            this.fillCurVal();
            this.bitOffset = 0;
        }
        return this.curVal >> 7 - this.bitOffset & 1;
    }

    private void fillCurVal() {
        try {
            int next = this.in.read();
            if (next < 0) {
                throw new BitIoError("Unexpected EOF");
            }
            this.curVal = (byte)next;
        }
        catch (IOException excep) {
            throw new BitIoError(excep.toString());
        }
    }
}

