/*
 * Decompiled with CFR 0.152.
 */
package qdbm;

import java.util.Random;
import qdbm.Depot;
import qdbm.DepotException;
import qdbm.Util;

class DepotTester
extends Thread {
    private static final int LOOPNUM = 10000;
    private static final int BUCKETNUM = 1000;
    private static final int THREADNUM = 10;
    private static final Random RND = new Random();
    private Depot mydepot;
    private int myid;
    private boolean myprinter;
    private DepotException myde;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usege: java qdbm.DepotTester name");
            return;
        }
        if (!DepotTester.dowrite(stringArray[0])) {
            System.exit(1);
        }
        if (!DepotTester.doread(stringArray[0])) {
            System.exit(1);
        }
        if (!DepotTester.domulti(stringArray[0])) {
            System.exit(1);
        }
        System.out.println("all ok");
        System.out.println("");
        System.exit(0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dowrite(String string) {
        System.out.println("<Writing Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        int n = 0;
        try {
            try {
                System.out.print("Creating ... ");
                depot = new Depot(string, 14, 1000);
                System.out.println("ok");
                System.out.println("Writing");
                int n2 = 1;
                while (true) {
                    if (n2 > 10000) {
                        System.out.println("ok");
                    }
                    byte[] byArray = Util.numstr(n2, 8, '0').getBytes();
                    depot.put(byArray, byArray, 0);
                    if (n2 % 40 == 0) {
                        System.out.print('.');
                        System.out.flush();
                        if (n2 == 10000 || n2 % 1000 == 0) {
                            System.out.println(" (" + new String(byArray) + ')');
                            System.out.flush();
                        }
                    }
                    ++n2;
                }
            }
            catch (DepotException depotException) {
                n = 1;
                System.err.println(depotException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
                throw throwable;
            }
            catch (DepotException depotException) {}
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        try {}
        catch (DepotException depotException) {}
        System.out.print("Closing ... ");
        if (depot != null) {
            depot.close();
        }
        System.out.println("ok");
        System.out.println("");
        return 1 - n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doread(String string) {
        System.out.println("<Reading Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        int n = 0;
        try {
            try {
                System.out.print("Opening ... ");
                depot = new Depot(string);
                System.out.println("ok");
                System.out.println("Reading");
                int n2 = 1;
                while (true) {
                    if (n2 > 10000) {
                        System.out.println("ok");
                    }
                    byte[] byArray = Util.numstr(n2, 8, '0').getBytes();
                    depot.get(byArray, 0, -1);
                    if (n2 % 40 == 0) {
                        System.out.print('.');
                        System.out.flush();
                        if (n2 == 10000 || n2 % 1000 == 0) {
                            System.out.println(" (" + new String(byArray) + ')');
                            System.out.flush();
                        }
                    }
                    ++n2;
                }
            }
            catch (DepotException depotException) {
                n = 1;
                System.err.println(depotException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
                throw throwable;
            }
            catch (DepotException depotException) {}
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        try {}
        catch (DepotException depotException) {}
        System.out.print("Closing ... ");
        if (depot != null) {
            depot.close();
        }
        System.out.println("ok");
        System.out.println("");
        return 1 - n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean domulti(String string) {
        System.out.println("<Multi-thread Test>");
        System.out.println("  name=" + string);
        System.out.println("");
        Depot depot = null;
        int n = 0;
        try {
            try {
                System.out.print("Opening ... ");
                depot = new Depot(string, 14, 1000);
                System.out.println("ok");
                DepotTester[] depotTesterArray = new DepotTester[10];
                System.out.println("Writing");
                int n2 = 0;
                while (true) {
                    if (n2 >= depotTesterArray.length) break;
                    boolean bl = false;
                    if (n2 == depotTesterArray.length / 2) {
                        bl = true;
                    }
                    depotTesterArray[n2] = new DepotTester(depot, n2, bl);
                    depotTesterArray[n2].start();
                    ++n2;
                }
                n2 = 0;
                while (true) {
                    if (n2 >= depotTesterArray.length) {
                        if (n == 0) {
                            System.out.println("ok");
                        }
                        break;
                    }
                    try {
                        depotTesterArray[n2].join();
                        if (depotTesterArray[n2].myde != null) {
                            n = 1;
                            System.err.println(depotTesterArray[n2].myde);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        --n2;
                    }
                    ++n2;
                }
                System.out.flush();
                System.out.print("Validation checking ... ");
                n2 = 1;
                while (true) {
                    block21: {
                        if (n2 <= 10000) break block21;
                        if (n == 0) {
                            System.out.println("ok");
                        }
                        break;
                    }
                    byte[] byArray = Util.numstr(n2, 8, '0').getBytes();
                    byte[] byArray2 = depot.get(byArray, 0, -1);
                    if (byArray2.length != 10) {
                        n = 1;
                        System.err.println("size error: " + byArray2.length);
                    }
                    ++n2;
                }
            }
            catch (DepotException depotException) {
                n = 1;
                System.err.println(depotException);
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            try {
                System.out.print("Closing ... ");
                if (depot != null) {
                    depot.close();
                }
                System.out.println("ok");
                throw throwable;
            }
            catch (DepotException depotException) {}
            throw throwable;
        }
        {
            Object var4_11 = null;
        }
        try {}
        catch (DepotException depotException) {}
        System.out.print("Closing ... ");
        if (depot != null) {
            depot.close();
        }
        System.out.println("ok");
        System.out.println("");
        return 1 - n;
    }

    public void run() {
        int n = 1;
        while (n <= 10000) {
            byte[] byArray = Util.numstr(n, 8, '0').getBytes();
            try {
                if (RND.nextInt(500) == 0) {
                    DepotTester.yield();
                }
                this.mydepot.put(byArray, (this.myid % 2 == 0 ? "=" : "*").getBytes(), 2);
            }
            catch (DepotException depotException) {
                this.myde = depotException;
                return;
            }
            if (this.myprinter && n % 40 == 0) {
                System.out.print('.');
                System.out.flush();
                if (n == 10000 || n % 1000 == 0) {
                    System.out.println(" (" + new String(byArray) + ')');
                    System.out.flush();
                    System.gc();
                }
            }
            ++n;
        }
    }

    private DepotTester(Depot depot, int n, boolean bl) {
        this.mydepot = depot;
        this.myid = n;
        this.myprinter = bl;
        this.myde = null;
    }
}

