/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.igoweb.util.LockOrder;

public class DatedFileHandler
extends StreamHandler {
    public static final LockOrder LOCK_ORDER = new LockOrder("DatedFileHandler");
    public static final String YEAR_MONTH_DAY_TEMPLATE = "{0,date,yyyy-MM-dd}";
    public static final String YEAR_MONTH_TEMPLATE = "{0,date,yyyy-MM}";
    public static final String DATE_TIME_TEMPLATE = "{0,date,yyyy-MM-dd-HH:mm}";
    private final MessageFormat filenameGenerator;
    private long rotateTime;
    private OutputStream out;
    private Calendar cal;
    private int rotatePeriod;

    public DatedFileHandler(String template) throws IOException {
        this(template, 5);
    }

    public DatedFileHandler(String template, int rotatePeriod) throws IOException {
        this.filenameGenerator = new MessageFormat(template, Locale.US);
        this.cal = new GregorianCalendar(Locale.US);
        this.rotatePeriod = rotatePeriod;
        try {
            this.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException excep) {
            throw new RuntimeException("UTF-8 not supported?", excep);
        }
        this.setLevel(Level.ALL);
        this.makeLogFile(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        try {
            assert (LockOrder.testAcquire(this));
            DatedFileHandler datedFileHandler = this;
            synchronized (datedFileHandler) {
                if (record.getMillis() >= this.rotateTime && this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.out == null) {
                    this.makeLogFile(record.getMillis());
                }
                super.publish(record);
                this.flush();
            }
        }
        catch (IOException excep) {
            this.close();
            this.reportError("I/O exception while logging", excep, 0);
        }
    }

    private void makeLogFile(long when) throws IOException {
        this.cal.setTimeInMillis(when);
        this.cal.set(14, 0);
        this.cal.set(13, 0);
        if (this.rotatePeriod < 12) {
            this.cal.set(12, 0);
            if (this.rotatePeriod < 11) {
                this.cal.set(11, 0);
                switch (this.rotatePeriod) {
                    case 3: {
                        this.cal.set(7, this.cal.getMinimum(7));
                        break;
                    }
                    case 2: {
                        this.cal.set(5, this.cal.getMinimum(5));
                        break;
                    }
                    case 1: {
                        this.cal.set(6, this.cal.getMinimum(6));
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown rotation period " + this.rotatePeriod);
                    }
                }
            }
        }
        this.out = new FileOutputStream(this.filenameGenerator.format(new Object[]{this.cal.getTime()}), true);
        this.cal.add(this.rotatePeriod, 1);
        this.rotateTime = this.cal.getTimeInMillis();
        this.setOutputStream(this.out);
    }

    static {
        LOCK_ORDER.orderFor(DatedFileHandler.class);
    }
}

