/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.gameInfo;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.igoweb.go.swing.sgf.gameInfo.DateInfo;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;

public class DateEditorWindow
extends DFrame {
    DateInfo date;
    private ATextField yearIn = new ATextField();
    private final JComboBox<String> monthChooser = new JComboBox();
    private ATextField dayIn = new ATextField();
    private ActionListener listener;
    private DefaultListModel<DateInfo> dates;
    private static final NumberFormat numFormat = NumberFormat.getInstance();
    private static final SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
    private static final SimpleDateFormat monthFormatter = new SimpleDateFormat("MMMM");
    private static final SimpleDateFormat dayFormatter = new SimpleDateFormat("d");

    public DateEditorWindow(DateInfo toEdit, Component align, DefaultListModel<DateInfo> dates, ActionListener listener) {
        super(Defs.getString(-478254135));
        this.date = toEdit == null ? new DateInfo() : toEdit;
        this.listener = listener;
        this.dates = dates;
        Calendar cal = yearFormatter.getCalendar();
        this.getMainPanel().add("xGrow=f,yGrow=f", new JLabel(Defs.getString(-478254167)));
        this.getMainPanel().add("xGrow=t", this.yearIn);
        if (this.date.getYear() != 0) {
            this.yearIn.setText(yearFormatter.format(this.date.getDate()));
        }
        this.getMainPanel().add("x=0,xGrow=f", new JLabel(Defs.getString(-478254154)));
        this.getMainPanel().add(this.monthChooser);
        this.monthChooser.addItem(Defs.getString(-478254141));
        for (int i = cal.getMinimum(2); i <= cal.getMaximum(2); ++i) {
            cal.set(2, i);
            this.monthChooser.addItem(monthFormatter.format(cal.getTime()));
        }
        if (this.date.getMonth() != 0) {
            cal.setTime(this.date.getDate());
            this.monthChooser.setSelectedIndex(cal.get(2) + 1 - cal.getMinimum(2));
        }
        this.getMainPanel().add("x=0", new JLabel(Defs.getString(-478254160)));
        this.getMainPanel().add(this.dayIn);
        if (this.date.getDay() != 0) {
            this.dayIn.setText(dayFormatter.format(this.date.getDate()));
        }
        this.addButton(Defs.getString(1436228518), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DateEditorWindow.this.okPressed();
            }
        });
        this.addButton(Defs.getString(1436228510), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DateEditorWindow.this.dispose();
            }
        });
        this.pack(align);
        this.setVisible(true);
    }

    private void okPressed() {
        Calendar cal = yearFormatter.getCalendar();
        GregorianCalendar stdCal = new GregorianCalendar();
        int month = 0;
        int day = 0;
        try {
            int year = numFormat.parse(this.yearIn.getText()).intValue();
            month = this.monthChooser.getSelectedIndex();
            if (month > 0 && !this.dayIn.getText().equals("")) {
                day = numFormat.parse(this.dayIn.getText()).intValue();
            }
            cal.set(1, year);
            if (month > 0) {
                cal.set(2, month - 1 + cal.getMinimum(2));
            }
            if (day > 0) {
                cal.set(5, day);
            }
            stdCal.setTime(cal.getTime());
            if (stdCal.get(1) > 0 && stdCal.get(0) == 1) {
                year = stdCal.get(1);
                if (month > 0) {
                    month = stdCal.get(2) - stdCal.getMinimum(2) + 1;
                }
                if (day > 0) {
                    day = stdCal.get(5);
                }
                if (year != this.date.getYear() || month != this.date.getMonth() || day != this.date.getDay()) {
                    this.dates.removeElement(this.date);
                    this.date.setYear(year);
                    this.date.setMonth(month);
                    this.date.setDay(day);
                    this.dates.addElement(this.date);
                    this.listener.actionPerformed(new ActionEvent(this, 1001, ""));
                }
                this.dispose();
                return;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        new Errout(Defs.getString(-478254175), this);
    }
}

