/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class XhtmlToHtmlFilter
extends FilterWriter {
    private boolean slashHeld = false;
    private boolean ltHeld = false;
    private int inComment = 0;

    public XhtmlToHtmlFilter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (this.testChar((char)c)) {
            this.out.write(c);
        }
    }

    private boolean testChar(char c) throws IOException {
        if (this.slashHeld) {
            if (c == '>') {
                this.slashHeld = false;
                return true;
            }
            this.out.write(47);
            this.slashHeld = false;
        } else {
            if (this.ltHeld) {
                this.ltHeld = false;
                if (c == '!') {
                    this.inComment = 1;
                    return false;
                }
                this.out.write(60);
                return true;
            }
            if (this.inComment > 0) {
                if (c == "---->".charAt(this.inComment - 1)) {
                    if (++this.inComment == 6) {
                        this.inComment = 0;
                    }
                } else {
                    this.inComment = 3;
                }
                return false;
            }
        }
        switch (c) {
            case '/': {
                this.slashHeld = true;
                break;
            }
            case '<': {
                this.ltHeld = true;
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int start = off;
        while (--len >= 0) {
            if (this.testChar(cbuf[off])) {
                ++off;
                continue;
            }
            if (start < off) {
                this.out.write(cbuf, start, off - start);
            }
            start = ++off;
        }
        if (start < off) {
            this.out.write(cbuf, start, off - start);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int start = off;
        while (--len >= 0) {
            if (this.testChar(str.charAt(off))) {
                ++off;
                continue;
            }
            if (start < off) {
                this.out.write(str, start, off - start);
            }
            start = ++off;
        }
        if (start < off) {
            this.out.write(str, start, off - start);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.slashHeld) {
            this.out.write(47);
        }
        this.slashHeld = false;
        this.out.close();
    }
}

